/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookLinkPage
extends BookTextPage {
    private final String url;
    private BookTextHolder linkText;

    public BookLinkPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, String url, BookTextHolder linkText) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.url = url;
        this.linkText = linkText;
    }

    public static BookLinkPage fromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        boolean useMarkdownInTitle = GsonHelper.getAsBoolean((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : new BookNoneCondition();
        String url = GsonHelper.getAsString((JsonObject)json, (String)"url", (String)"");
        BookTextHolder linkText = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"link_text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        return new BookLinkPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, url, linkText);
    }

    public static BookLinkPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String url = buffer.readUtf();
        BookTextHolder linkText = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        return new BookLinkPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, url, linkText);
    }

    public BookTextHolder getLinkText() {
        return this.linkText;
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.LINK_PAGE;
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.linkText.hasComponent()) {
            MutableComponent text = Component.translatable((String)this.linkText.getKey());
            Style style = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.url)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.nullToEmpty((String)this.url)));
            this.linkText = new BookTextHolder((Component)text.withStyle(style));
        }
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.writeUtf(this.url);
        this.linkText.toNetwork(buffer);
    }

    public boolean matchesQuery(String query) {
        return super.matchesQuery(query) || this.url.toLowerCase().contains(query) || this.linkText.getString().toLowerCase().contains(query);
    }
}

