/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.google.common.collect.Sets;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.LightShardBaseEntity;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LightMineEntity
extends LightShardBaseEntity {
    private static final int NO_POTION_COLOR = -1;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(LightMineEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean colorSet;
    protected final Set<MobEffectInstance> effects = Sets.newHashSet();

    public LightMineEntity(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    public LightMineEntity(Level world, LivingEntity owner, float detectionRange, float damage, float lifeSpanTicks) {
        super((EntityType<? extends Projectile>)((EntityType)PastelEntityTypes.LIGHT_MINE.get()), world, owner, detectionRange, damage, lifeSpanTicks);
    }

    public static void summonBarrage(Level world, @Nullable LivingEntity user, @Nullable LivingEntity target, Predicate<LivingEntity> targetPredicate, List<MobEffectInstance> effects, Vec3 position, IntProvider count) {
        LightMineEntity.summonBarrageInternal(world, user, () -> {
            LightMineEntity mine = new LightMineEntity(world, user, 8.0f, 1.0f, 800.0f);
            mine.setEffects(effects);
            return mine;
        }, target, targetPredicate, position, count);
    }

    public void setEffects(List<MobEffectInstance> effects) {
        this.effects.addAll(effects);
        if (this.effects.isEmpty()) {
            this.setColor(0xFFFFFF);
        } else {
            this.setColor(PotionContents.getColor(this.effects));
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    private void setColor(int color) {
        this.colorSet = true;
        this.entityData.set(COLOR, (Object)color);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.colorSet) {
            nbt.putInt("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            CodecHelper.writeNbt(nbt, "custom_potion_effects", MobEffectInstance.CODEC.listOf(), this.effects.stream().toList());
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setEffects(CodecHelper.fromNbt(MobEffectInstance.CODEC.listOf(), nbt.get("custom_potion_effects"), List.of()));
        if (nbt.contains("Color", 99)) {
            this.setColor(nbt.getInt("Color"));
        } else {
            this.colorSet = false;
            if (this.effects.isEmpty()) {
                this.entityData.set(COLOR, (Object)-1);
            } else {
                this.entityData.set(COLOR, (Object)PotionContents.getColor(this.effects));
            }
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return PastelCommon.locate("textures/entity/projectile/light_mine.png");
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)-1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.tickCount % 4 == 0) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        if (!this.effects.isEmpty()) {
            int color = this.getColor();
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onHitEntity(LivingEntity attacked) {
        super.onHitEntity(attacked);
        Entity attacker = this.getEffectSource();
        for (MobEffectInstance statusEffectInstance : this.effects) {
            attacked.addEffect(new MobEffectInstance(statusEffectInstance.getEffect(), Math.max(statusEffectInstance.getDuration() / 8, 1), statusEffectInstance.getAmplifier(), statusEffectInstance.isAmbient(), statusEffectInstance.isVisible()), attacker);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance statusEffectInstance : this.effects) {
                attacked.addEffect(statusEffectInstance, attacker);
            }
        }
    }
}

