/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailLeftoverHandler;
import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightShardBaseEntity
extends Projectile {
    public static final Predicate<LivingEntity> EVERYTHING_TARGET = livingEntity -> {
        Player player;
        return !(livingEntity instanceof Player) || !(player = (Player)livingEntity).isCreative();
    };
    public static final Predicate<LivingEntity> MONSTER_TARGET = livingEntity -> livingEntity instanceof Enemy;
    public static final IntProvider DEFAULT_COUNT_PROVIDER = UniformInt.of((int)7, (int)13);
    private static final EntityDataAccessor<Integer> MAX_AGE = SynchedEntityData.defineId(LightShardBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int DECELERATION_PHASE_LENGTH = 25;
    protected float scaleOffset;
    protected float damage;
    protected float detectionRange;
    protected Optional<UUID> target = Optional.empty();
    protected Optional<LivingEntity> targetEntity = Optional.empty();
    protected Vec3 initialVelocity = Vec3.ZERO;
    protected Predicate<LivingEntity> targetPredicate;
    private boolean shouldRenderTrail;
    private TrailRender trail;

    public LightShardBaseEntity(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
        this.scaleOffset = world.random.nextFloat() + 0.15f;
    }

    public LightShardBaseEntity(EntityType<? extends Projectile> entityType, Level world, LivingEntity owner, float detectionRange, float damage, float lifeSpanTicks) {
        super(entityType, world);
        this.setOwner((Entity)owner);
        this.detectionRange = detectionRange;
        this.damage = damage;
        this.setMaxAge((int)(lifeSpanTicks + Mth.normal((RandomSource)world.getRandom(), (float)10.0f, (float)7.0f)));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MAX_AGE, (Object)20);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(MAX_AGE, (Object)maxAge);
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (!this.shouldRenderTrail && this.level().isClientSide() && this.tickCount > 24 && this.getDeltaMovement().length() > 0.075) {
            this.shouldRenderTrail = true;
            this.noCulling = true;
        }
        if (this.tickCount > this.getMaxAge()) {
            this.playSound(PastelSounds.SOFT_HUM, this.random.nextFloat() + 0.25f, 1.0f + this.random.nextFloat());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Vec3 velocity = this.getDeltaMovement();
        this.absMoveTo(this.getX() + velocity.x(), this.getY() + velocity.y(), this.getZ() + velocity.z());
        if (this.tickCount < 25) {
            double deceleration = Math.max((double)((float)this.tickCount / 25.0f), 0.5);
            this.setDeltaMovement(Mth.lerp((double)deceleration, (double)this.initialVelocity.x, (double)0.0), Mth.lerp((double)deceleration, (double)this.initialVelocity.y, (double)0.0), Mth.lerp((double)deceleration, (double)this.initialVelocity.z, (double)0.0));
            this.hasImpulse = true;
            this.markHurt();
            return;
        }
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        this.onHit(hitResult);
        if (this.targetEntity.isEmpty() || !this.isStillValidTarget(this.targetEntity.get())) {
            Level world = this.level();
            if (world.isClientSide) {
                return;
            }
            if ((double)this.random.nextFloat() > 0.25) {
                return;
            }
            this.findSuitableTargets((ServerLevel)this.level());
        }
        if (this.targetEntity.isPresent()) {
            LivingEntity target = this.targetEntity.get();
            double vel = Math.min(this.getDeltaMovement().length() + 0.05, 1.8);
            Vec3 homeVector = target.position().add(0.0, (double)target.getEyeHeight() * 0.75, 0.0).subtract(this.position()).normalize();
            Vec3 curVector = this.getDeltaMovement().normalize();
            Vec3 finalVector = curVector.scale(0.85).add(homeVector.scale(0.15)).scale(vel);
            this.setDeltaMovement(finalVector);
        }
    }

    protected void setTargetPredicate(@NotNull Predicate<LivingEntity> targetPredicate) {
        this.targetPredicate = targetPredicate;
    }

    protected void findSuitableTargets(ServerLevel serverWorld) {
        List potentialTargets = serverWorld.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)this.position(), (double)this.detectionRange, (double)this.detectionRange, (double)this.detectionRange), this.targetPredicate);
        Collections.shuffle(potentialTargets);
        for (LivingEntity potentialTarget : potentialTargets) {
            if (!this.canSee((Entity)potentialTarget) || !this.isValidTarget(potentialTarget)) continue;
            this.setTarget(potentialTarget);
            return;
        }
    }

    public boolean canSee(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        if (entity.position().distanceTo(this.position()) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext(this.position(), entity.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    protected boolean isStillValidTarget(LivingEntity entity) {
        return entity.isAlive() && !entity.isInvisible();
    }

    protected boolean isValidTarget(LivingEntity entity) {
        LivingEntity livingEntity;
        OwnableEntity pet;
        LivingEntity petOwner;
        Entity owner = this.getOwner();
        if (entity == owner) {
            return false;
        }
        if (owner != null && entity.isAlliedTo(owner)) {
            return false;
        }
        if (!this.targetPredicate.test(entity)) {
            return false;
        }
        if (entity instanceof OwnableEntity && (petOwner = (pet = (OwnableEntity)entity).getOwner()) instanceof LivingEntity && this.targetPredicate.test(livingEntity = petOwner)) {
            return false;
        }
        return !entity.isRemoved() && entity.isAlive() && !entity.isInvisible() && !entity.isInvulnerable();
    }

    protected void setInitialVelocity(Vec3 vector) {
        this.initialVelocity = vector;
        this.setDeltaMovement(vector);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (!this.level().isClientSide()) {
            Entity hitEntity = entityHitResult.getEntity();
            if (!(hitEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            this.onHitEntity(livingEntity);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        super.onHitEntity(entityHitResult);
    }

    protected void onHitEntity(LivingEntity attacked) {
        LivingEntity owner;
        Entity entity;
        float finalDamage = this.damage * (this.random.nextFloat() + 0.5f) * (1.0f - this.getVanishingProgress(this.tickCount));
        attacked.hurt(PastelDamageTypes.irradiance(this.level(), (entity = this.getOwner()) instanceof LivingEntity ? (owner = (LivingEntity)entity) : null), finalDamage);
        attacked.playSound(PastelSounds.SOFT_HUM, 1.334f, 0.9f + this.random.nextFloat());
        attacked.playSound(PastelSounds.CRYSTAL_STRIKE, this.random.nextFloat() * 0.4f + 0.2f, 0.8f + this.random.nextFloat());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientRemoval() {
        TrailRender render = this.getTrail();
        if (render != null) {
            TrailLeftoverHandler.addTrail((TrailRender)render, (MultiBufferSource)RenderHandler.createBufferSource(), (int)0xF000F0, (ColorGradient)this.getGradient());
            this.shouldRenderTrail = false;
        }
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        int bound = this.random.nextInt(11);
        if (reason.shouldDestroy()) {
            for (int i = 0; i < bound + 5; ++i) {
                if ((double)this.random.nextFloat() < 0.665) {
                    this.level().addAlwaysVisibleParticle((ParticleOptions)ColoredSparkleRisingParticleEffect.WHITE, true, this.getX(), this.getY(), this.getZ(), (double)(this.random.nextFloat() * 0.25f - 0.125f), (double)(this.random.nextFloat() * 0.25f - 0.125f), (double)(this.random.nextFloat() * 0.25f - 0.125f));
                    continue;
                }
                this.level().addAlwaysVisibleParticle((ParticleOptions)PastelParticleTypes.SHOOTING_STAR, true, this.getX(), this.getY(), this.getZ(), (double)(this.random.nextFloat() * 0.5f - 0.25f), (double)(this.random.nextFloat() * 0.5f - 0.25f), (double)(this.random.nextFloat() * 0.5f - 0.25f));
            }
        }
    }

    public static void summonBarrageInternal(Level world, @Nullable LivingEntity user, Supplier<LightShardBaseEntity> supplier, @Nullable LivingEntity target, Predicate<LivingEntity> targetPredicate, Vec3 pos, IntProvider count) {
        RandomSource random = world.getRandom();
        int projectiles = count.sample(random);
        world.playSound(null, BlockPos.containing((Position)pos), PastelSounds.GLASS_SHIMMER, SoundSource.AMBIENT, 1.0f, 0.9f + random.nextFloat() * 0.5f);
        for (int i = 0; i < projectiles; ++i) {
            LightShardBaseEntity shard = supplier.get();
            shard.setPos(pos);
            double velocityY = 0.0;
            if (user != null && user.onGround()) {
                velocityY = (double)random.nextFloat() * 0.75;
                shard.setInitialVelocity(new Vec3((double)(random.nextFloat() * 2.0f - 1.0f), velocityY, (double)(random.nextFloat() * 2.0f - 1.0f)).add(user.getDeltaMovement()));
            } else {
                velocityY = (double)random.nextFloat() - 0.5;
                shard.setInitialVelocity(new Vec3((double)(random.nextFloat() * 2.0f - 1.0f), velocityY, (double)(random.nextFloat() * 2.0f - 1.0f)));
            }
            if (target != null) {
                shard.setTarget(target);
            }
            shard.setTargetPredicate(targetPredicate);
            world.addFreshEntity((Entity)shard);
            for (int j = 0; j < 3; ++j) {
                world.addParticle((ParticleOptions)PastelParticleTypes.SHOOTING_STAR, pos.x, pos.y, pos.z, (double)(random.nextFloat() * 0.8f - 0.4f), velocityY * 2.0, (double)(random.nextFloat() * 0.8f - 0.4f));
            }
        }
    }

    public float getScaleOffset() {
        return this.scaleOffset;
    }

    public float getVanishingProgress(int age) {
        return 1.0f - (float)Math.min(this.getMaxAge() - age, this.getVanishingLength()) / (float)this.getVanishingLength();
    }

    public int getVanishingLength() {
        return Math.round((float)this.getMaxAge() / 4.0f);
    }

    public void setTarget(@NotNull LivingEntity target) {
        this.target = Optional.ofNullable(target.getUUID());
        this.targetEntity = Optional.of(target);
    }

    public ColorGradient getGradient() {
        return new ColorGradient(new Color(0xFFFFFF), new Color(-8377404)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }

    public TrailRender getTrail() {
        if (!this.shouldRenderTrail) {
            return null;
        }
        if (this.trail == null) {
            this.trail = new TrailRender(this.position(), 20, 20, 0.125f, PastelCommon.locate("textures/misc/trail/trail.png"), RenderTypeHandler::transparent).setShrink(true).startTicking();
        }
        return this.trail;
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.target.ifPresent(uuid -> nbt.putUUID("target", uuid));
        nbt.putDouble("initX", this.initialVelocity.x);
        nbt.putDouble("initY", this.initialVelocity.y);
        nbt.putDouble("initZ", this.initialVelocity.z);
        nbt.putFloat("damage", this.damage);
        nbt.putFloat("scale", this.scaleOffset);
        nbt.putInt("maxAge", this.getMaxAge());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("target")) {
            this.target = Optional.ofNullable(nbt.getUUID("target"));
        }
        this.initialVelocity = new Vec3(nbt.getDouble("initX"), nbt.getDouble("initY"), nbt.getDouble("initZ"));
        this.damage = nbt.getFloat("damage");
        this.scaleOffset = nbt.getFloat("scale");
        this.setMaxAge(nbt.getInt("maxAge"));
    }

    public abstract ResourceLocation getTextureLocation();
}

