/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.MagicProjectileEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.level.AoEHelper;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.spells.MoonstoneStrike;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class MiningProjectileEntity
extends MagicProjectileEntity {
    private static final int MINING_RANGE = 1;
    private ItemStack toolStack = ItemStack.EMPTY;

    public MiningProjectileEntity(EntityType<MiningProjectileEntity> type, Level world) {
        super(type, world);
    }

    public MiningProjectileEntity(double x, double y, double z, Level world) {
        this((EntityType<MiningProjectileEntity>)((EntityType)PastelEntityTypes.MINING_PROJECTILE.get()), world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
    }

    public MiningProjectileEntity(Level world, LivingEntity owner) {
        this(owner.getX(), owner.getEyeY() - 0.1, owner.getZ(), world);
        this.setOwner((Entity)owner);
        this.setRot(owner.getYRot(), owner.getXRot());
    }

    public static void shoot(Level world, LivingEntity entity, ItemStack stack) {
        MiningProjectileEntity projectile = new MiningProjectileEntity(world, entity);
        projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 2.0f, 1.0f);
        projectile.toolStack = stack.copy();
        world.addFreshEntity((Entity)projectile);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    public void tick() {
        super.tick();
        this.spawnParticles(1);
    }

    private void spawnParticles(int amount) {
        for (int j = 0; j < amount; ++j) {
            this.level().addParticle((ParticleOptions)ColoredCraftingParticleEffect.WHITE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        this.strike();
        this.discard();
    }

    private void strike() {
        MoonstoneStrike.create(this.level(), (Entity)this, null, this.getX(), this.getY(), this.getZ(), 1.0f, Support.varFloatCentered(this.random, 0.3f) - 0.1f);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.strike();
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Predicate<BlockState> minablePredicate = state -> {
                float hardness = state.getDestroySpeed((BlockGetter)this.level(), blockHitResult.getBlockPos());
                if (hardness < 0.0f) {
                    return false;
                }
                boolean suitable = this.toolStack.isCorrectToolForDrops(state);
                int efficiencyLevel = Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, this.toolStack);
                return hardness <= (float)(6 + (suitable ? 4 + efficiencyLevel : 0));
            };
            AoEHelper.breakBlocksAround(player, this.toolStack, blockHitResult.getBlockPos(), 1, minablePredicate);
        }
        this.discard();
    }

    @Override
    public void spawnImpactParticles() {
    }

    @Override
    public InkColor getInkColor() {
        return InkColors.WHITE;
    }
}

