/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.ai.FixedBodyControl;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PreservationTurretEntity
extends AbstractGolem
implements Enemy,
VibrationSystem {
    protected static final int DETECTION_RANGE = 16;
    protected static final float DAMAGE = 4.0f;
    private static final ResourceLocation COVERED_ARMOR_BONUS_ID = PastelCommon.locate("covered_armor");
    private static final ResourceLocation COVERED_TOUGHNESS_BONUS_ID = PastelCommon.locate("covered_toughness");
    protected static final AttributeModifier COVERED_ARMOR_BONUS = new AttributeModifier(COVERED_ARMOR_BONUS_ID, 20.0, AttributeModifier.Operation.ADD_VALUE);
    protected static final AttributeModifier COVERED_TOUGHNESS_BONUS = new AttributeModifier(COVERED_TOUGHNESS_BONUS_ID, 6.0, AttributeModifier.Operation.ADD_VALUE);
    protected static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(PreservationTurretEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    protected static final EntityDataAccessor<Byte> PEEK_AMOUNT = SynchedEntityData.defineId(PreservationTurretEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final Vector3f SOUTH_VECTOR = (Vector3f)Util.make(() -> {
        Vec3i vec3i = Direction.SOUTH.getNormal();
        return new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
    });
    protected final TargetingConditions TARGET_PREDICATE = TargetingConditions.forCombat();
    protected final DynamicGameEventListener<VibrationSystem.Listener> gameEventHandler = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
    protected final VibrationSystem.User vibrationCallback = new VibrationsCallback(this);
    protected VibrationSystem.Data vibrationListenerData = new VibrationSystem.Data();
    protected float prevOpenProgress;
    protected float openProgress;
    @Nullable
    protected BlockPos prevAttachedBlock;

    public PreservationTurretEntity(EntityType<? extends PreservationTurretEntity> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 12;
        this.lookControl = new TurretLookControl((Mob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RatatatataGoal());
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f, 0.04f, true));
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        if (effect.getEffect().is(PastelMobEffectTags.SOPORIFIC)) {
            return false;
        }
        return super.canBeAffected(effect);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return PastelSounds.ENTITY_PRESERVATION_TURRET_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return PastelSounds.ENTITY_PRESERVATION_TURRET_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.isClosed() ? PastelSounds.ENTITY_PRESERVATION_TURRET_HURT_CLOSED : PastelSounds.ENTITY_PRESERVATION_TURRET_HURT;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(PEEK_AMOUNT, (Object)0);
    }

    public static AttributeSupplier.Builder createGuardianTurretAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0);
    }

    protected BodyRotationControl createBodyControl() {
        return new FixedBodyControl((Mob)this);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("AttachFace", (byte)this.getAttachedFace().get3DDataValue());
        nbt.putByte("Peek", ((Byte)this.entityData.get(PEEK_AMOUNT)).byteValue());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setAttachedFace(Direction.from3DDataValue((int)nbt.getByte("AttachFace")));
        this.entityData.set(PEEK_AMOUNT, (Object)nbt.getByte("Peek"));
    }

    public VibrationSystem.Data getVibrationData() {
        return this.vibrationListenerData;
    }

    public VibrationSystem.User getVibrationUser() {
        return this.vibrationCallback;
    }

    public void playAmbientSound() {
        if (this.getPeekAmount() > 0) {
            super.playAmbientSound();
        }
    }

    public void tick() {
        Direction direction;
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            VibrationSystem.Ticker.tick((Level)serverWorld, (VibrationSystem.Data)this.getVibrationData(), (VibrationSystem.User)this.getVibrationUser());
        }
        if (!(this.level().isClientSide() || this.isPassenger() || this.canStay(this.blockPosition(), this.getAttachedFace()) || (direction = this.findAttachSide(this.blockPosition())) == null)) {
            this.setAttachedFace(direction);
        }
        this.tickOpenProgress();
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> callback) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            callback.accept(this.gameEventHandler, serverWorld);
        }
    }

    private void tickOpenProgress() {
        this.prevOpenProgress = this.openProgress;
        float peekAmount = (float)this.getPeekAmount() * 0.01f;
        if (this.openProgress != peekAmount) {
            this.openProgress = this.openProgress > peekAmount ? Mth.clamp((float)(this.openProgress - 0.05f), (float)peekAmount, (float)1.0f) : Mth.clamp((float)(this.openProgress + 0.05f), (float)0.0f, (float)peekAmount);
        }
    }

    public Vec3 getVehicleAttachmentPoint(Entity vehicle) {
        if (vehicle.getType() != EntityType.BOAT && vehicle.getType() != EntityType.MINECART) {
            return super.getVehicleAttachmentPoint(vehicle);
        }
        Vec3 ridingPos = vehicle.getPassengerRidingPosition((Entity)this);
        return new Vec3(ridingPos.x, 0.1875 - ridingPos.y, ridingPos.z);
    }

    public boolean startRiding(Entity entity, boolean force) {
        if (this.level().isClientSide()) {
            this.prevAttachedBlock = null;
        }
        this.setAttachedFace(Direction.DOWN);
        return super.startRiding(entity, force);
    }

    public void stopRiding() {
        super.stopRiding();
        if (this.level().isClientSide()) {
            this.prevAttachedBlock = this.blockPosition();
        }
        this.yBodyRotO = 0.0f;
        this.yBodyRot = 0.0f;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setYRot(0.0f);
        this.yHeadRot = this.getYRot();
        this.setOldPosAndRot();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void setPos(double x, double y, double z) {
        BlockPos blockPos2;
        BlockPos blockPos = this.blockPosition();
        if (this.isPassenger()) {
            super.setPos(x, y, z);
        } else {
            super.setPos((double)Mth.floor((double)x) + 0.5, (double)Mth.floor((double)(y + 0.5)), (double)Mth.floor((double)z) + 0.5);
        }
        if (this.tickCount != 0 && !(blockPos2 = this.blockPosition()).equals((Object)blockPos)) {
            this.entityData.set(PEEK_AMOUNT, (Object)0);
            this.hasImpulse = true;
            if (this.level().isClientSide() && !this.isPassenger() && !blockPos2.equals((Object)this.prevAttachedBlock)) {
                this.prevAttachedBlock = blockPos;
                this.xOld = this.getX();
                this.yOld = this.getY();
                this.zOld = this.getZ();
            }
        }
    }

    @Nullable
    protected Direction findAttachSide(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canStay(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean canStay(BlockPos pos, Direction direction) {
        if (this.isInvalidPosition(pos)) {
            return false;
        }
        Direction direction2 = direction.getOpposite();
        if (!this.level().loadedAndEntityCanStandOnFace(pos.relative(direction), (Entity)this, direction2)) {
            return false;
        }
        return this.level().noCollision((Entity)this, this.getBoundingBox());
    }

    private boolean isInvalidPosition(BlockPos pos) {
        BlockState blockState = this.level().getBlockState(pos);
        if (blockState.isAir()) {
            return false;
        }
        boolean bl = blockState.is(Blocks.MOVING_PISTON) && pos.equals((Object)this.blockPosition());
        return !bl;
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpSteps = 0;
        this.setPos(x, y, z);
        this.setRot(yaw, pitch);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isClosed() && source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        return super.hurt(source, amount);
    }

    private boolean isClosed() {
        return this.getPeekAmount() == 0;
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public Direction getAttachedFace() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    private void setAttachedFace(Direction face) {
        this.entityData.set(ATTACHED_FACE, (Object)face);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (ATTACHED_FACE.equals(data)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        super.onSyncedDataUpdated(data);
    }

    private int getPeekAmount() {
        return ((Byte)this.entityData.get(PEEK_AMOUNT)).byteValue();
    }

    void setPeekAmount(int peekAmount) {
        if (!this.level().isClientSide()) {
            this.getAttribute(Attributes.ARMOR).removeModifier(COVERED_ARMOR_BONUS);
            this.getAttribute(Attributes.ARMOR_TOUGHNESS).removeModifier(COVERED_TOUGHNESS_BONUS);
            if (peekAmount == 0) {
                this.getAttribute(Attributes.ARMOR).addPermanentModifier(COVERED_ARMOR_BONUS);
                this.getAttribute(Attributes.ARMOR_TOUGHNESS).addPermanentModifier(COVERED_TOUGHNESS_BONUS);
                this.playSound(PastelSounds.ENTITY_PRESERVATION_TURRET_CLOSE, 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.CONTAINER_CLOSE);
            } else {
                this.playSound(PastelSounds.ENTITY_PRESERVATION_TURRET_OPEN, 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.CONTAINER_OPEN);
            }
        }
        this.entityData.set(PEEK_AMOUNT, (Object)((byte)peekAmount));
    }

    public float getOpenProgress(float delta) {
        return Mth.lerp((float)delta, (float)this.prevOpenProgress, (float)this.openProgress);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.yBodyRot = 0.0f;
        this.yBodyRotO = 0.0f;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public int getMaxHeadYRot() {
        return 180;
    }

    public void push(Entity entity) {
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 thisEyePos = this.getEyePosition();
        Vec3 entityEyePos = entity.getEyePosition();
        double distance = entityEyePos.distanceTo(thisEyePos);
        return distance < 26.0 && (Math.abs(this.getEyeY() - entity.getEyeY()) < distance / 2.0 || Math.abs(this.getEyeY() - entity.getY()) < distance / 2.0) && this.level().clip(new ClipContext(thisEyePos, entityEyePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    public float getPickRadius() {
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean isValidTarget(@Nullable Entity entity) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.level() != entity.level()) return false;
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)) return false;
        if (this.isAlliedTo(entity)) return false;
        if (livingEntity.getType() == EntityType.ARMOR_STAND) return false;
        if (livingEntity.getType() == PastelEntityTypes.PRESERVATION_TURRET.get()) return false;
        if (livingEntity.isInvulnerable()) return false;
        if (livingEntity.isDeadOrDying()) return false;
        if (!this.level().getWorldBorder().isWithinBounds(livingEntity.getBoundingBox())) return false;
        return true;
    }

    private class VibrationsCallback
    implements VibrationSystem.User {
        private final EntityPositionSource positionSource;

        VibrationsCallback(PreservationTurretEntity turretEntity) {
            this.positionSource = new EntityPositionSource((Entity)turretEntity, turretEntity.getEyeHeight());
        }

        public int getListenerRadius() {
            return 16;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public boolean canReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, GameEvent.Context emitter) {
            LivingEntity livingEntity;
            Entity entity;
            return !PreservationTurretEntity.this.isRemoved() && !PreservationTurretEntity.this.isDeadOrDying() && !PreservationTurretEntity.this.isNoAi() && world.getWorldBorder().isWithinBounds(pos) && PreservationTurretEntity.this.level() == world && (entity = emitter.sourceEntity()) instanceof LivingEntity && PreservationTurretEntity.this.isValidTarget((Entity)(livingEntity = (LivingEntity)entity));
        }

        public void onReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, @Nullable Entity sourceEntity, @Nullable Entity target, float distance) {
            LivingEntity livingEntity;
            if (!PreservationTurretEntity.this.isDeadOrDying() && sourceEntity instanceof LivingEntity && PreservationTurretEntity.this.TARGET_PREDICATE.test((LivingEntity)PreservationTurretEntity.this, livingEntity = (LivingEntity)sourceEntity)) {
                PreservationTurretEntity.this.setTarget(livingEntity);
                PreservationTurretEntity.this.setPeekAmount(100);
            }
        }
    }

    private class TurretLookControl
    extends LookControl {
        public TurretLookControl(Mob entity) {
            super(entity);
        }

        protected void clampHeadRotationToBody() {
        }

        protected Optional<Float> getYRotD() {
            Direction attachedDirection = PreservationTurretEntity.this.getAttachedFace().getOpposite();
            Vector3f southVectorCopy = new Vector3f((Vector3fc)SOUTH_VECTOR);
            southVectorCopy.rotate((Quaternionfc)attachedDirection.getRotation());
            Vec3i vec3i = attachedDirection.getNormal();
            Vector3f vec3f2 = new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
            vec3f2.cross((Vector3fc)southVectorCopy);
            double xOffset = this.wantedX - this.mob.getX();
            double yOffset = this.wantedY - this.mob.getEyeY();
            double zOffset = this.wantedZ - this.mob.getZ();
            Vector3f vec3f3 = new Vector3f((float)xOffset, (float)yOffset, (float)zOffset);
            float g = vec3f2.dot((Vector3fc)vec3f3);
            float h = southVectorCopy.dot((Vector3fc)vec3f3);
            return !(Math.abs(g) > 1.0E-5f) && !(Math.abs(h) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(Mth.atan2((double)(-g), (double)h) * 57.2957763671875)));
        }

        protected Optional<Float> getXRotD() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class RatatatataGoal
    extends Goal {
        public RatatatataGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity target = PreservationTurretEntity.this.getTarget();
            if (target != null) {
                PreservationTurretEntity.this.getLookControl().setLookAt((Entity)target, 2.0f, 2.0f);
                if (!PreservationTurretEntity.this.hasLineOfSight((Entity)target)) {
                    PreservationTurretEntity.this.setTarget(null);
                    return false;
                }
            }
            return target != null && target.isAlive() && (double)PreservationTurretEntity.this.openProgress == 1.0 && PreservationTurretEntity.this.TARGET_PREDICATE.test((LivingEntity)PreservationTurretEntity.this, PreservationTurretEntity.this.getTarget());
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && PreservationTurretEntity.this.TARGET_PREDICATE.test((LivingEntity)PreservationTurretEntity.this, PreservationTurretEntity.this.getTarget());
        }

        public void stop() {
            PreservationTurretEntity.this.setPeekAmount(0);
        }

        public void tick() {
            if (PreservationTurretEntity.this.level().getDifficulty() != Difficulty.PEACEFUL) {
                LivingEntity target = PreservationTurretEntity.this.getTarget();
                if (target == null) {
                    return;
                }
                if (!PreservationTurretEntity.this.hasLineOfSight((Entity)target)) {
                    return;
                }
                target.hurt(PreservationTurretEntity.this.level().damageSources().mobAttack((LivingEntity)PreservationTurretEntity.this), 4.0f);
                PreservationTurretEntity.this.playSound(PastelSounds.ENTITY_PRESERVATION_TURRET_SHOOT, 2.0f, 1.0f + 0.2f * (PreservationTurretEntity.this.random.nextFloat() - PreservationTurretEntity.this.random.nextFloat()));
                target.playSound(PastelSounds.ENTITY_PRESERVATION_TURRET_SHOOT, 1.0f, 0.5f + 0.2f * (PreservationTurretEntity.this.random.nextFloat() - PreservationTurretEntity.this.random.nextFloat()));
                super.tick();
            }
        }
    }
}

