/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.entity.entity.EggLayingWoolyPigEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EggLayingWoolyPigEntityModel
extends EntityModel<EggLayingWoolyPigEntity> {
    protected final ModelPart torso;
    protected final ModelPart head;
    protected final ModelPart left_foreleg;
    protected final ModelPart right_foreleg;
    protected final ModelPart left_backleg;
    protected final ModelPart right_backleg;
    private float headPitchModifier;

    public EggLayingWoolyPigEntityModel(ModelPart root) {
        this.torso = root.getChild("torso");
        this.head = this.torso.getChild("head");
        this.left_foreleg = this.torso.getChild("left_foreleg");
        this.right_foreleg = this.torso.getChild("right_foreleg");
        this.left_backleg = this.torso.getChild("left_backleg");
        this.right_backleg = this.torso.getChild("right_backleg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition torso = modelPartData.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(42, 47).addBox(-5.0f, -14.0f, -7.0f, 10.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = torso.addOrReplaceChild("head", CubeListBuilder.create().texOffs(56, 24).addBox(-4.0f, -6.0f, -6.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(-2.5f, -2.0f, -7.0f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 73).addBox(2.5f, -8.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 73).addBox(-3.5f, -8.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)-7.0f));
        head.addOrReplaceChild("ear_r1", CubeListBuilder.create().texOffs(0, 0).addBox(7.0964f, -13.0939f, -10.5f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        head.addOrReplaceChild("ear_r2", CubeListBuilder.create().texOffs(0, 32).addBox(-10.0964f, -13.0939f, -10.5f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        torso.addOrReplaceChild("left_foreleg", CubeListBuilder.create().texOffs(54, 69).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-6.0f, (float)-4.0f));
        torso.addOrReplaceChild("right_foreleg", CubeListBuilder.create().texOffs(38, 69).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-6.0f, (float)-4.0f));
        torso.addOrReplaceChild("left_backleg", CubeListBuilder.create().texOffs(0, 61).addBox(-3.0f, -2.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(61, 40).addBox(-3.0f, 4.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-8.0f, (float)5.0f));
        torso.addOrReplaceChild("right_backleg", CubeListBuilder.create().texOffs(39, 34).addBox(-2.0f, -2.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(0.0f, 4.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-8.0f, (float)5.0f));
        torso.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, 61).addBox(-2.5f, -15.0f, 7.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void prepareMobModel(EggLayingWoolyPigEntity entity, float limbAngle, float limbDistance, float tickDelta) {
        super.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
        this.head.y = -13.0f + entity.getNeckAngle(tickDelta) * 9.0f;
        this.headPitchModifier = entity.getHeadAngle(tickDelta);
    }

    public void setupAnim(EggLayingWoolyPigEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.xRot = this.headPitchModifier;
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.right_backleg.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.left_backleg.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.right_foreleg.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.left_foreleg.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            matrices.scale(0.6f, 0.6f, 0.6f);
            matrices.translate(0.0f, 1.0f, 0.0f);
        }
        this.torso.render(matrices, vertices, light, overlay, color);
    }
}

