/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LizardEntityModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart tail;
    private final ModelPart lower_tail;
    private final ModelPart jaw;

    public LizardEntityModel(ModelPart root) {
        super(true, 8.0f, 3.35f);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
        this.lower_tail = this.tail.getChild("lower_tail");
        this.jaw = this.head.getChild("jaw");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(23, 18).addBox(-3.5f, -3.0f, -9.0f, 7.0f, 7.0f, 11.0f).texOffs(0, 0).addBox(0.0f, -15.0f, -9.0f, 0.0f, 12.0f, 17.0f).texOffs(48, 13).addBox(-3.0f, -3.0f, 2.0f, 6.0f, 7.0f, 6.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition rightbackleg = modelPartData.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 65).addBox(0.0f, -1.5f, -2.0f, 3.0f, 4.0f, 4.0f).texOffs(9, 2).addBox(1.0f, 2.5f, -3.0f, 2.0f, 0.0f, 1.0f), PartPose.offset((float)3.0f, (float)21.5f, (float)6.0f));
        rightbackleg.addOrReplaceChild("rightbackfrills_r1", CubeListBuilder.create().texOffs(0, 21).addBox(0.9f, -3.5f, -3.9f, 0.0f, 7.0f, 8.0f), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition leftbackleg = modelPartData.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.5f, -2.0f, 3.0f, 4.0f, 4.0f).texOffs(9, 0).addBox(-3.0f, 2.5f, -3.0f, 2.0f, 0.0f, 1.0f), PartPose.offset((float)-3.0f, (float)21.5f, (float)6.0f));
        leftbackleg.addOrReplaceChild("leftbackfrills_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.9f, -3.5f, -3.9f, 0.0f, 7.0f, 8.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition rightforeleg = modelPartData.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(66, 9).addBox(0.0f, -1.5f, -2.0f, 2.0f, 4.0f, 4.0f).texOffs(9, 3).addBox(0.0f, 2.5f, -3.0f, 2.0f, 0.0f, 1.0f), PartPose.offset((float)3.5f, (float)21.5f, (float)-5.0f));
        rightforeleg.addOrReplaceChild("rightfrills_r1", CubeListBuilder.create().texOffs(31, 60).addBox(-0.75f, -4.0f, -1.0f, 0.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition leftforeleg = modelPartData.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(31, 58).addBox(-2.0f, -1.5f, -2.0f, 2.0f, 4.0f, 4.0f).texOffs(9, 1).addBox(-2.0f, 2.5f, -3.0f, 2.0f, 0.0f, 1.0f), PartPose.offset((float)-3.5f, (float)21.5f, (float)-5.0f));
        leftforeleg.addOrReplaceChild("leftfrills_r1", CubeListBuilder.create().texOffs(36, 37).addBox(0.75f, -4.0f, -1.0f, 0.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition neartail = modelPartData.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(18, 44).addBox(-2.5f, -4.0f, 0.0f, 5.0f, 6.0f, 8.0f).texOffs(44, 48).addBox(0.0f, -15.0f, 0.0f, 0.0f, 11.0f, 8.0f), PartPose.offset((float)0.0f, (float)20.5f, (float)8.0f));
        PartDefinition midtail = neartail.addOrReplaceChild("lower_tail", CubeListBuilder.create().texOffs(45, 0).addBox(-2.0f, -3.0f, 0.0f, 4.0f, 5.0f, 8.0f).texOffs(0, 42).addBox(0.0f, -14.0f, 0.0f, 0.0f, 11.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        midtail.addOrReplaceChild("fartail", CubeListBuilder.create().texOffs(56, 28).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 4.0f, 8.0f).texOffs(0, 0).addBox(-7.0f, 1.0f, 0.0f, 14.0f, 0.0f, 17.0f).texOffs(0, 23).addBox(0.0f, -12.0f, 0.0f, 0.0f, 14.0f, 13.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)8.0f));
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(11, 58).addBox(-2.5f, -4.0f, -5.0f, 5.0f, 6.0f, 5.0f).texOffs(44, 44).addBox(-2.0f, -4.0f, -14.0f, 4.0f, 3.0f, 9.0f).texOffs(26, 21).addBox(0.0f, -11.0f, -15.0f, 0.0f, 8.0f, 15.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)-9.0f));
        head.addOrReplaceChild("rightfrills_r2", CubeListBuilder.create().texOffs(61, 40).addBox(-1.9733f, -9.9307f, 0.0f, 8.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)2.5f, (float)-4.0f, (float)-5.0f, (float)-0.8281f, (float)0.001f, (float)1.5679f));
        head.addOrReplaceChild("leftfrills_r2", CubeListBuilder.create().texOffs(45, 68).addBox(-6.0267f, -9.9307f, 0.0f, 8.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.0f, (float)-5.0f, (float)-0.8282f, (float)0.0f, (float)-1.5615f));
        head.addOrReplaceChild("topfrills_r1", CubeListBuilder.create().texOffs(60, 56).addBox(-4.5f, -11.75f, -0.15f, 9.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-5.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(61, 0).addBox(-1.5f, 0.0f, -5.5f, 3.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leftHindLeg.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.tail.yRot = this.lerpAngleDegrees(this.tail.yRot, 0.3f * Mth.cos((float)(animationProgress * 0.1f)));
        this.lower_tail.yRot = this.lerpAngleDegrees(this.tail.yRot, 0.3f * Mth.cos((float)(animationProgress * 0.1f)));
        this.jaw.xRot = 0.3f * this.lerpAngleDegrees(this.tail.yRot, 0.05f * Mth.cos((float)(animationProgress * 0.1f)));
    }

    private float lerpAngleDegrees(float start, float end) {
        return Mth.rotLerp((float)0.05f, (float)start, (float)end);
    }
}

