/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.models;

import com.google.common.collect.ImmutableList;
import earth.terrarium.pastel.entity.entity.PreservationTurretEntity;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PreservationTurretEntityModel<T extends PreservationTurretEntity>
extends ListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart cover;

    public PreservationTurretEntityModel(ModelPart root) {
        super(RenderType::entityCutoutNoCullZOffset);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.cover = this.body.getChild("cover");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition body = modelData.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 8.0f, 16.0f, CubeDeformation.NONE).texOffs(0, 24).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 2.0f, 16.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(48, 0).addBox(-5.0f, -14.0f, -5.0f, 10.0f, 6.0f, 10.0f, CubeDeformation.NONE), PartPose.ZERO);
        body.addOrReplaceChild("cover", CubeListBuilder.create().texOffs(0, 42).addBox(-7.0f, -14.0f, -7.0f, 14.0f, 6.0f, 14.0f, CubeDeformation.NONE), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void setupAnim(T turretEntity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float k = animationProgress - (float)((PreservationTurretEntity)((Object)turretEntity)).tickCount;
        float l = (float)((double)(0.5f + ((PreservationTurretEntity)((Object)turretEntity)).getOpenProgress(k)) * Math.PI);
        float coverOffset = 0.0f;
        if ((double)l > Math.PI) {
            coverOffset = Mth.sin((float)(animationProgress * 0.1f)) * 0.7f;
        }
        this.cover.setPos(0.0f, 8.0f - Mth.sin((float)l) * 8.0f - coverOffset, 0.0f);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (((PreservationTurretEntity)((Object)turretEntity)).getOpenProgress(k) > 0.3f) {
            this.head.yRot = (((PreservationTurretEntity)((Object)turretEntity)).yHeadRot - 180.0f - ((PreservationTurretEntity)((Object)turretEntity)).yBodyRot) * ((float)Math.PI / 180);
        }
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

