/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.entity.PastelEntitySubPredicateTypes;
import earth.terrarium.pastel.entity.entity.EggLayingWoolyPigEntity;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record EggLayingWoolyPigPredicate(Optional<DyeColor> color, Optional<Boolean> hatless, Optional<Boolean> sheared) implements EntitySubPredicate
{
    public static final MapCodec<EggLayingWoolyPigPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(EggLayingWoolyPigPredicate::color), (App)Codec.BOOL.optionalFieldOf("hatless").forGetter(EggLayingWoolyPigPredicate::hatless), (App)Codec.BOOL.optionalFieldOf("sheared").forGetter(EggLayingWoolyPigPredicate::sheared)).apply((Applicative)instance, EggLayingWoolyPigPredicate::new));

    public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
        if (!(entity instanceof EggLayingWoolyPigEntity)) {
            return false;
        }
        EggLayingWoolyPigEntity wooly = (EggLayingWoolyPigEntity)entity;
        return !(!this.color.isEmpty() && this.color.get() != wooly.getColor() || !this.hatless.isEmpty() && this.hatless.get().booleanValue() != wooly.isHatless() || !this.sheared.isEmpty() && this.sheared.get().booleanValue() != wooly.isSheared());
    }

    public MapCodec<EggLayingWoolyPigPredicate> codec() {
        return PastelEntitySubPredicateTypes.EGG_LAYING_WOOLY_PIG;
    }
}

