/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.entity.PastelEntitySubPredicateTypes;
import earth.terrarium.pastel.entity.entity.LizardEntity;
import earth.terrarium.pastel.entity.variants.LizardFrillVariant;
import earth.terrarium.pastel.entity.variants.LizardHornVariant;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record LizardPredicate(Optional<InkColor> color, Optional<LizardFrillVariant> frills, Optional<LizardHornVariant> horns) implements EntitySubPredicate
{
    public static final MapCodec<LizardPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)InkColor.CODEC.optionalFieldOf("color").forGetter(LizardPredicate::color), (App)LizardFrillVariant.CODEC.optionalFieldOf("frills_variant").forGetter(LizardPredicate::frills), (App)LizardHornVariant.CODEC.optionalFieldOf("horn_variant").forGetter(LizardPredicate::horns)).apply((Applicative)instance, LizardPredicate::new));

    public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
        if (!(entity instanceof LizardEntity)) {
            return false;
        }
        LizardEntity lizard = (LizardEntity)entity;
        return !(!this.color.isEmpty() && this.color.get() != lizard.getColor() || !this.frills.isEmpty() && this.frills.get() != lizard.getFrills() || !this.horns.isEmpty() && this.horns.get() != lizard.getHorns());
    }

    public MapCodec<LizardPredicate> codec() {
        return PastelEntitySubPredicateTypes.LIZARD;
    }
}

