/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.GlassArrowEntity;
import earth.terrarium.pastel.registries.client.PastelModelLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlassArrowEntityRenderer
extends EntityRenderer<GlassArrowEntity> {
    private final ResourceLocation TEXTURE = PastelCommon.locate("textures/entity/projectile/arrow/white_glass_arrow.png");
    private final Model model;

    public GlassArrowEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new Model(context.bakeLayer(PastelModelLayers.GLASS_ARROW));
    }

    public void render(GlassArrowEntity arrow, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource buffers, int light) {
        this.renderType(arrow, tickDelta, poseStack, buffers);
        super.render((Entity)arrow, yaw, tickDelta, poseStack, buffers, light);
    }

    public boolean shouldRender(GlassArrowEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    private void renderType(GlassArrowEntity arrow, float tickDelta, PoseStack poseStack, MultiBufferSource consumers) {
        TrailRender trail = arrow.getTrail();
        if (trail != null) {
            poseStack.pushPose();
            double d0 = Mth.lerp((double)tickDelta, (double)arrow.xOld, (double)arrow.getX());
            double d1 = Mth.lerp((double)tickDelta, (double)arrow.yOld, (double)arrow.getY());
            double d2 = Mth.lerp((double)tickDelta, (double)arrow.zOld, (double)arrow.getZ());
            Vec3 posOffset = new Vec3(d0, d1, d2).subtract(arrow.position());
            Vec3 pos = arrow.position().add(posOffset);
            poseStack.translate(-pos.x, -pos.y, -pos.z);
            trail.position = arrow.getBoundingBox().getCenter().add(posOffset);
            trail.render(poseStack, (MultiBufferSource)RenderHandler.createBufferSource(), 0xF000F0, arrow.getGradient());
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, -1.25f, 0.0f);
        VertexConsumer buffer = consumers.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(arrow)));
        this.model.main.setRotation((float)Math.toRadians(Mth.lerp((float)tickDelta, (float)arrow.xRotO, (float)arrow.getXRot()) + 90.0f), (float)Math.toRadians(Mth.lerp((float)tickDelta, (float)arrow.yRotO, (float)arrow.getYRot()) - 180.0f), 0.0f);
        float alpha = 1.0f - Math.min((float)arrow.getInGroundTime() / 20.0f, 1.0f);
        this.model.renderToBuffer(poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f));
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(GlassArrowEntity arrow) {
        return arrow.getVariant().getTexture();
    }

    public static class Model
    extends EntityModel<GlassArrowEntity> {
        private final ModelPart main;

        public Model(ModelPart root) {
            this.main = root.getChild("bone");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.5f, (float)24.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)-1.5708f));
            PartDefinition face_r1 = bone.addOrReplaceChild("face_r1", CubeListBuilder.create().texOffs(1, 0).addBox(-2.5f, -12.0f, 0.0f, 5.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
            PartDefinition face_r2 = bone.addOrReplaceChild("face_r2", CubeListBuilder.create().texOffs(1, 0).addBox(-2.5f, -12.0f, 0.0f, 5.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
        }

        public void setupAnim(GlassArrowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            this.main.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }
}

