/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.KindlingEntity;
import earth.terrarium.pastel.entity.models.KindlingEntityModel;
import earth.terrarium.pastel.entity.render.KindlingEntityArmorFeatureRenderer;
import earth.terrarium.pastel.entity.variants.KindlingVariant;
import earth.terrarium.pastel.registries.client.PastelModelLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class KindlingEntityRenderer
extends MobRenderer<KindlingEntity, KindlingEntityModel> {
    public static final ResourceLocation SADDLE_TEXTURE = PastelCommon.locate("textures/entity/kindling/saddle.png");

    public KindlingEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new KindlingEntityModel(context.bakeLayer(PastelModelLayers.KINDLING)), 0.7f);
        this.addLayer((RenderLayer)new SaddleLayer((RenderLayerParent)this, (EntityModel)new KindlingEntityModel(context.bakeLayer(PastelModelLayers.KINDLING_SADDLE)), SADDLE_TEXTURE));
        this.addLayer(new KindlingEntityArmorFeatureRenderer((RenderLayerParent<KindlingEntity, KindlingEntityModel>)this, context.getModelSet()));
    }

    public void render(KindlingEntity entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light) {
        super.render((LivingEntity)entity, yaw, tickDelta, poseStack, vertexConsumerProvider, light);
    }

    public ResourceLocation getTextureLocation(@NotNull KindlingEntity entity) {
        boolean isBlinking;
        KindlingVariant variant = entity.getKindlingVariant();
        boolean isClipped = entity.isClipped();
        if (entity.getRemainingPersistentAngerTime() > 0) {
            return isClipped ? variant.getAngryClippedTexture() : variant.getAngryTexture();
        }
        boolean bl = isBlinking = ((long)entity.getId() - entity.level().getGameTime()) % 120L == 0L;
        if (isClipped) {
            return isBlinking ? variant.getBlinkingClippedTexture() : variant.getClippedTexture();
        }
        return isBlinking ? variant.getBlinkingTexture() : variant.getDefaultTexture();
    }

    protected boolean isShaking(KindlingEntity entity) {
        return entity.getEepyTime() > 0;
    }
}

