/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.entity.entity.LightShardEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LightShardEntityRenderer
extends EntityRenderer<LightShardEntity> {
    public LightShardEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(LightShardEntity shard, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        LightShardEntityRenderer.renderTrail(shard, tickDelta, matrices);
        matrices.pushPose();
        int age = shard.tickCount;
        float alpha = Mth.clamp((float)(1.0f - Mth.lerp((float)tickDelta, (float)shard.getVanishingProgress(age - 1), (float)shard.getVanishingProgress(age))), (float)0.0f, (float)1.0f);
        float scaleFactor = Mth.sin((float)(((float)age + tickDelta) / 16.0f)) / 10.0f + shard.getScaleOffset();
        double size = shard.getBoundingBox().getSize() / 2.0;
        matrices.translate(0.0, size, 0.0);
        matrices.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrices.scale(scaleFactor, scaleFactor, scaleFactor);
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(shard)));
        PoseStack.Pose matrix = matrices.last();
        Matrix4f positions = matrix.pose();
        consumer.addVertex(positions, -0.5f, -0.5f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 0.5f, -0.5f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 0.5f, 0.5f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, -0.5f, 0.5f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        matrices.popPose();
        super.render((Entity)shard, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private static void renderTrail(LightShardEntity shard, float tickDelta, PoseStack matrices) {
        TrailRender trail = shard.getTrail();
        if (trail == null) {
            return;
        }
        matrices.pushPose();
        double d0 = Mth.lerp((double)tickDelta, (double)shard.xOld, (double)shard.getX());
        double d1 = Mth.lerp((double)tickDelta, (double)shard.yOld, (double)shard.getY());
        double d2 = Mth.lerp((double)tickDelta, (double)shard.zOld, (double)shard.getZ());
        Vec3 posOffset = new Vec3(d0, d1, d2).subtract(shard.position());
        Vec3 pos = shard.position().add(posOffset);
        matrices.translate(-pos.x, -pos.y, -pos.z);
        trail.position = shard.getBoundingBox().getCenter().add(posOffset);
        trail.render(matrices, (MultiBufferSource)RenderHandler.createBufferSource(), 0xF000F0, shard.getGradient());
        matrices.popPose();
    }

    public ResourceLocation getTextureLocation(LightShardEntity entity) {
        return entity.getTextureLocation();
    }
}

