/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.LizardEntity;
import earth.terrarium.pastel.entity.models.LizardEntityModel;
import earth.terrarium.pastel.entity.render.LizardEyesFeatureRenderer;
import earth.terrarium.pastel.entity.render.LizardFrillsFeatureRenderer;
import earth.terrarium.pastel.entity.render.LizardHornsFeatureRenderer;
import earth.terrarium.pastel.registries.client.PastelModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LizardEntityRenderer
extends MobRenderer<LizardEntity, LizardEntityModel<LizardEntity>> {
    public static final ResourceLocation TEXTURE = PastelCommon.locate("textures/entity/lizard/lizard.png");
    public static final ResourceLocation TEXTURE_BLINKING = PastelCommon.locate("textures/entity/lizard/lizard_blinking.png");

    public LizardEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new LizardEntityModel(context.bakeLayer(PastelModelLayers.LIZARD_SCALES)), 0.8f);
        this.addLayer((RenderLayer)new LizardEyesFeatureRenderer(this));
        this.addLayer(new LizardHornsFeatureRenderer(this));
        this.addLayer(new LizardFrillsFeatureRenderer(this));
    }

    public ResourceLocation getTextureLocation(LizardEntity entity) {
        return ((long)entity.getId() - entity.level().getGameTime()) % 120L == 0L ? TEXTURE_BLINKING : TEXTURE;
    }
}

