/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.entity.entity.MagicProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class MagicProjectileEntityRenderer
extends EntityRenderer<MagicProjectileEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/entity/experience_orb.png");
    private static final RenderType LAYER = RenderType.itemEntityTranslucentCull((ResourceLocation)TEXTURE);

    public MagicProjectileEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(MagicProjectileEntity magicProjectileEntity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light) {
        poseStack.pushPose();
        Vector3f starColor = magicProjectileEntity.getInkColor().getColorVec();
        double time = (float)(magicProjectileEntity.level().getGameTime() % 24000L) + tickDelta + (float)RandomSource.create((long)magicProjectileEntity.getId()).nextInt(200);
        float scale = 0.75f + 0.1f * (float)Math.sin(time / 10.0);
        poseStack.scale(scale, scale, scale);
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(LAYER);
        float h = 0.75f;
        float k = 1.0f;
        float l = 0.0f;
        float m = 0.25f;
        int s = (int)(starColor.x() * 255.0f);
        int t = (int)(starColor.y() * 255.0f);
        int u = (int)(starColor.z() * 255.0f);
        PoseStack.Pose entry = poseStack.last();
        Matrix4f matrix4f = entry.pose();
        poseStack.translate(0.0, (double)0.1f, 0.0);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        MagicProjectileEntityRenderer.vertex(vertexConsumer, entry, matrix4f, -0.5f, -0.25f, s, t, u, h, m, light);
        MagicProjectileEntityRenderer.vertex(vertexConsumer, entry, matrix4f, 0.5f, -0.25f, s, t, u, k, m, light);
        MagicProjectileEntityRenderer.vertex(vertexConsumer, entry, matrix4f, 0.5f, 0.75f, s, t, u, k, l, light);
        MagicProjectileEntityRenderer.vertex(vertexConsumer, entry, matrix4f, -0.5f, 0.75f, s, t, u, h, l, light);
        poseStack.popPose();
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose matrix, Matrix4f positionMatrix, float x, float y, int red, int green, int blue, float u, float v, int light) {
        vertexConsumer.addVertex(positionMatrix, x, y, 0.0f).setColor(red, green, blue, 128).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(matrix, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(MagicProjectileEntity entity) {
        return TEXTURE;
    }
}

