/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.entity.entity.PastelFishingBobberEntity;
import earth.terrarium.pastel.items.tools.PastelFishingRodItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public abstract class PastelFishingBobberEntityRenderer
extends EntityRenderer<PastelFishingBobberEntity> {
    public PastelFishingBobberEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public abstract RenderType getLayer(PastelFishingBobberEntity var1);

    public void render(PastelFishingBobberEntity fishingBobberEntity, float f, float g, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int i) {
        Player playerEntity = fishingBobberEntity.getPlayerOwner();
        if (playerEntity != null) {
            poseStack.pushPose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            PoseStack.Pose entry = poseStack.last();
            VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(this.getLayer(fishingBobberEntity));
            PastelFishingBobberEntityRenderer.vertex(vertexConsumer, entry, i, 0.0f, 0, 0, 1);
            PastelFishingBobberEntityRenderer.vertex(vertexConsumer, entry, i, 1.0f, 0, 1, 1);
            PastelFishingBobberEntityRenderer.vertex(vertexConsumer, entry, i, 1.0f, 1, 1, 0);
            PastelFishingBobberEntityRenderer.vertex(vertexConsumer, entry, i, 0.0f, 1, 0, 0);
            poseStack.popPose();
            float h = playerEntity.getAttackAnim(g);
            float j = Mth.sin((float)(Mth.sqrt((float)h) * (float)Math.PI));
            Vec3 vec3d = this.getHandPos(playerEntity, j, g);
            Vec3 vec3d2 = fishingBobberEntity.getPosition(g).add(0.0, 0.25, 0.0);
            float k = (float)(vec3d.x - vec3d2.x);
            float l = (float)(vec3d.y - vec3d2.y);
            float m = (float)(vec3d.z - vec3d2.z);
            VertexConsumer vertexConsumer2 = vertexConsumerProvider.getBuffer(RenderType.lineStrip());
            PoseStack.Pose entry2 = poseStack.last();
            for (int o = 0; o <= 16; ++o) {
                PastelFishingBobberEntityRenderer.renderFishingLine(fishingBobberEntity, k, l, m, vertexConsumer2, entry2, PastelFishingBobberEntityRenderer.percentage(o, 16), PastelFishingBobberEntityRenderer.percentage(o + 1, 16));
            }
            poseStack.popPose();
            super.render((Entity)fishingBobberEntity, f, g, poseStack, vertexConsumerProvider, i);
        }
    }

    private Vec3 getHandPos(Player player, float f, float tickDelta) {
        int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemStack = player.getMainHandItem();
        if (!(itemStack.getItem() instanceof PastelFishingRodItem)) {
            i = -i;
        }
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double m = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3d = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f).scale(m).yRot(f * 0.5f).xRot(-f * 0.7f);
            return player.getEyePosition(tickDelta).add(vec3d);
        }
        float g = Mth.lerp((float)tickDelta, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d = Mth.sin((float)g);
        double e = Mth.cos((float)g);
        float h = player.getScale();
        double j = (double)i * 0.35 * (double)h;
        double k = 0.8 * (double)h;
        float l = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(tickDelta).add(-e * j - d * k, (double)l - 0.45 * (double)h, -d * j + e * k);
    }

    private static float percentage(int value, int max) {
        return (float)value / (float)max;
    }

    private static void vertex(VertexConsumer buffer, PoseStack.Pose matrix, int light, float x, int y, int u, int v) {
        buffer.addVertex(matrix, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(-1).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(matrix, 0.0f, 1.0f, 0.0f);
    }

    private static void renderFishingLine(PastelFishingBobberEntity bobber, float x, float y, float z, VertexConsumer buffer, PoseStack.Pose matrices, float segmentStart, float segmentEnd) {
        float f = x * segmentStart;
        float g = y * (segmentStart * segmentStart + segmentStart) * 0.5f + 0.25f;
        float h = z * segmentStart;
        float i = x * segmentEnd - f;
        float j = y * (segmentEnd * segmentEnd + segmentEnd) * 0.5f + 0.25f - g;
        float k = z * segmentEnd - h;
        float l = Mth.sqrt((float)(i * i + j * j + k * k));
        buffer.addVertex(matrices, f, g, h).setColor(bobber.getLineColor()).setNormal(matrices, i /= l, j /= l, k /= l);
    }
}

