/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.variants;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelRegistries;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;

public enum LizardFrillVariant implements StringRepresentable
{
    SIMPLE("simple", "textures/entity/lizard/frills_simple.png"),
    FANCY("fancy", "textures/entity/lizard/frills_fancy.png"),
    RUFFLED("ruffled", "textures/entity/lizard/frills_ruffled.png"),
    MODEST("modest", "textures/entity/lizard/frills_modest.png"),
    NONE("none", "textures/entity/lizard/frills_none.png");

    public static Codec<LizardFrillVariant> CODEC;
    private final String name;
    private final ResourceLocation id;
    private final ResourceLocation texture;

    private LizardFrillVariant(String name, String texture) {
        this.name = name;
        this.id = PastelCommon.locate(name);
        this.texture = PastelCommon.locate(texture);
        Registry.register(PastelRegistries.LIZARD_FRILL_VARIANT, (ResourceLocation)this.id, (Object)((Object)this));
    }

    public TagKey<LizardFrillVariant> getReference() {
        return TagKey.create((ResourceKey)PastelRegistries.LIZARD_FRILL_VARIANT.key(), (ResourceLocation)this.id);
    }

    public ResourceLocation getTextureLocation() {
        return this.texture;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(LizardFrillVariant::values);
    }
}

