/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.interaction.ItemProvider;
import earth.terrarium.pastel.api.render.DynamicItemRenderer;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import earth.terrarium.pastel.attachments.data.SpectacleData;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.data_loaders.ParticleSpawnerParticlesDataLoader;
import earth.terrarium.pastel.data_loaders.dimension.ColorGradingLoader;
import earth.terrarium.pastel.data_loaders.dimension.EnvDataLoader;
import earth.terrarium.pastel.deeper_down.Environmental;
import earth.terrarium.pastel.deeper_down.EnvironmentalData;
import earth.terrarium.pastel.deeper_down.HowlingSpireEffects;
import earth.terrarium.pastel.helpers.level.BuildingHelper;
import earth.terrarium.pastel.helpers.render.TooltipHelper;
import earth.terrarium.pastel.items.magic_items.BuildingStaffItem;
import earth.terrarium.pastel.items.magic_items.ConstructorsStaffItem;
import earth.terrarium.pastel.items.magic_items.ExchangeStaffItem;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import earth.terrarium.pastel.mixin.client.accessors.WorldRendererAccessor;
import earth.terrarium.pastel.particle.render.ExtendedParticleManager;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.registries.client.PastelColorProviders;
import earth.terrarium.pastel.registries.client.PastelShaders;
import earth.terrarium.pastel.render.HudRenderers;
import earth.terrarium.pastel.render.item.SlotEffectDecorator;
import earth.terrarium.pastel.sound.AuraSoundInstance;
import earth.terrarium.pastel.sound.BiomeSoundInstance;
import earth.terrarium.pastel.sound.WorldAttenuation;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

@OnlyIn(value=Dist.CLIENT)
public class PastelClientEvents {
    private static boolean postProcessWasOn = PastelCommon.CONFIG.PostProcess;

    private static void registerCustomItemRenderer(Item item, Supplier<DynamicItemRenderer> renderer) {
        DynamicItemRenderer.RENDERERS.put((Object)item, (Object)renderer.get());
    }

    public static void register(IEventBus pastelBus) {
        pastelBus.addListener(PastelClientEvents::onReloadClientResources);
        pastelBus.addListener(PastelColorProviders::registerBlocks);
        pastelBus.addListener(PastelColorProviders::registerItems);
        pastelBus.addListener(PastelClientEvents::addResourcePacks);
        pastelBus.addListener(PastelClientEvents::registerDecorators);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::onWorldRenderStart);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::handlePlayerRendering);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::onRenderBlockOutlines);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::onLogout);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::onLogin);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::onDrawTooltips);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::afterClientTick);
        NeoForge.EVENT_BUS.addListener(PastelClientEvents::onEntityTick);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, PastelClientEvents::modifyFog);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, PastelClientEvents::modifyFogColor);
    }

    private static void registerDecorators(RegisterItemDecorationsEvent e) {
        PastelClientEvents.slotEffect(PastelItems.INK_ASSORTMENT, e);
        PastelClientEvents.slotEffect(PastelItems.CREATIVE_INK_ASSORTMENT, e);
        PastelClientEvents.slotEffect(PastelItems.INK_FLASK, e);
        PastelClientEvents.slotEffect(PastelItems.PIGMENT_PALETTE, e);
        PastelClientEvents.slotEffect(PastelItems.ARTISTS_PALETTE, e);
        PastelClientEvents.slotEffect(PastelItems.KNOTTED_SWORD, e);
        PastelClientEvents.slotEffect(PastelItems.NECTAR_LANCE, e);
        PastelClientEvents.slotEffect(PastelItems.DRACONIC_TWINSWORD, e);
        PastelClientEvents.slotEffect(PastelItems.DRAGON_TALON, e);
        PastelClientEvents.slotEffect(PastelItems.DREAMFLAYER, e);
        PastelClientEvents.slotEffect(PastelItems.NIGHTFALLS_BLADE, e);
        PastelClientEvents.slotEffect(PastelItems.NECTARDEW_BURGEON, e);
        PastelClientEvents.slotEffect(PastelItems.AETHER_VESTIGES, e);
        PastelClientEvents.slotEffect(PastelItems.SOOTHING_BOUQUET, e);
        PastelClientEvents.slotEffect(PastelItems.MYSTERIOUS_COMPASS, e);
        PastelClientEvents.slotEffect(PastelItems.MYSTERIOUS_LOCKET, e);
        PastelClientEvents.slotEffect(PastelItems.FRACTAL_GLASS_CREST_BIDENT, e);
        PastelClientEvents.slotEffect(PastelItems.FEROCIOUS_GLASS_CREST_BIDENT, e);
        PastelClientEvents.slotEffect(PastelItems.GLASS_CREST_CROSSBOW, e);
        PastelClientEvents.slotEffect(PastelItems.GLASS_CREST_ULTRA_GREATSWORD, e);
        PastelClientEvents.slotEffect(PastelItems.OMNI_ACCELERATOR, e);
        PastelClientEvents.slotEffect(PastelBlocks.CRYSTALLARIEUM, e);
        PastelClientEvents.slotEffect(PastelItems.AETHER_GRACED_NECTAR_GLOVES, e);
        PastelClientEvents.slotEffect(PastelItems.PRISCILLENT_SPECTACLES, e);
        InkDrainTrinketItem.BY_COLOR.values().forEach(i -> PastelClientEvents.slotEffect((ItemLike)i, e));
    }

    private static void slotEffect(ItemLike item, RegisterItemDecorationsEvent event) {
        event.register(item, (IItemDecorator)new SlotEffectDecorator());
    }

    private static void modifyFog(ViewportEvent.RenderFog event) {
        Environmental.State state = Environmental.isActive();
        float far = event.getFarPlaneDistance();
        if (state.force()) {
            far *= 1.25f;
        }
        float original = far;
        if (state.overrides) {
            far = Environmental.getFar(far);
            event.setNearPlaneDistance(Environmental.getNear(event.getNearPlaneDistance(), !state.force()));
        }
        if (state.force()) {
            event.setFogShape(FogShape.SPHERE);
            far = Math.min(far, original);
        }
        event.setFarPlaneDistance(far);
        event.setCanceled(state.overrides);
    }

    private static void modifyFogColor(ViewportEvent.ComputeFogColor event) {
        if (!Environmental.isActive().overrides) {
            return;
        }
        float red = event.getRed();
        float green = event.getGreen();
        float blue = event.getBlue();
        EnvironmentalData envData = Environmental.getEnvData();
        float darkening = envData.brightMult();
        if (darkening < 1.0f) {
            red *= darkening;
            green *= darkening;
            blue *= darkening;
        }
        float[] colors = new float[]{red, green, blue};
        Environmental.applyColor(colors);
        event.setRed(colors[0]);
        event.setGreen(colors[1]);
        event.setBlue(colors[2]);
    }

    private static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        if (player.level().dimension().equals(PastelLevels.DIMENSION_KEY) && PastelCommon.CONFIG.PostProcess) {
            PastelClientEvents.initializeColorGrading(Minecraft.getInstance());
        }
    }

    private static void addResourcePacks(AddPackFindersEvent event) {
        event.addPackFinders(PastelCommon.locate("pastel_style_amethyst"), PackType.CLIENT_RESOURCES, (Component)Component.literal((String)"Pastel-Style Amethyst"), PackSource.BUILT_IN, false, Pack.Position.TOP);
    }

    private static void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PrimordialFireData.clientTick(living);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SpectacleData.tickClient(player);
        }
    }

    private static void afterClientTick(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = client.level;
        Entity cameraEntity = client.getCameraEntity();
        if (level == null || cameraEntity == null) {
            BiomeSoundInstance.clear();
            AuraSoundInstance.clear();
            return;
        }
        boolean inDim = level.dimension().equals(PastelLevels.DIMENSION_KEY);
        Holder biome = level.getBiome(client.getCameraEntity().blockPosition());
        HowlingSpireEffects.clientTick(level, cameraEntity, (Holder<Biome>)biome);
        Environmental.tick(cameraEntity);
        WorldAttenuation.tick((Level)level, cameraEntity, inDim);
        if (PastelCommon.CONFIG.PostProcess && inDim) {
            if (!postProcessWasOn) {
                PastelClientEvents.initializeColorGrading(client);
                postProcessWasOn = true;
            }
            PastelShaders.updateDimensionShaders(level);
        } else if (postProcessWasOn) {
            PastelShaders.clearDimensionShaders();
            postProcessWasOn = false;
        }
    }

    private static void onDrawTooltips(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        List lines = event.getTooltipElements();
        if (stack.has(DataComponents.FOOD) && BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().equals("pastel")) {
            TooltipHelper.addFoodComponentEffectTooltip(stack, lines, Item.TooltipContext.EMPTY.tickRate());
        }
        if (stack.is(PastelItemTags.COMING_SOON_TOOLTIP)) {
            lines.add(Either.left((Object)Component.translatable((String)"pastel.tooltip.coming_soon").withStyle(ChatFormatting.RED)));
        }
    }

    private static void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        Pastel.clearClientInstance();
        PastelShaders.clearDimensionShaders();
    }

    private static void onRenderBlockOutlines(RenderHighlightEvent.Block event) {
        boolean shouldCancel = false;
        BlockHitResult target = event.getTarget();
        Camera camera = event.getCamera();
        Minecraft client = Minecraft.getInstance();
        if (client.player != null) {
            for (ItemStack handStack : client.player.getHandSlots()) {
                Item handItem = handStack.getItem();
                if (handItem instanceof ConstructorsStaffItem) {
                    shouldCancel = PastelClientEvents.renderPlacementStaffOutline(event.getPoseStack(), camera, camera.getPosition().x, camera.getPosition().y, camera.getPosition().z, event.getMultiBufferSource(), target);
                    break;
                }
                if (!(handItem instanceof ExchangeStaffItem)) continue;
                shouldCancel = PastelClientEvents.renderExchangeStaffOutline(event.getPoseStack(), camera, camera.getPosition().x, camera.getPosition().y, camera.getPosition().z, event.getMultiBufferSource(), handStack, target);
                break;
            }
        }
        event.setCanceled(shouldCancel);
    }

    private static void onWorldRenderStart(RenderLevelStageEvent event) {
        RenderLevelStageEvent.Stage stage = event.getStage();
        if (stage == RenderLevelStageEvent.Stage.AFTER_SKY) {
            HudRenderers.clearItemStackOverlay();
        } else {
            Entity focusedEntity;
            Minecraft minecraft = Minecraft.getInstance();
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            if (stage == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                ((ExtendedParticleManager)minecraft.particleEngine).render(event.getPoseStack(), (MultiBufferSource)bufferSource, event.getCamera(), event.getPartialTick().getGameTimeDeltaTicks());
            } else if (stage == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && (focusedEntity = event.getCamera().getEntity()) instanceof LivingEntity) {
                Pastel.getClientInstance().renderLines(minecraft.level, event.getPoseStack(), (MultiBufferSource)bufferSource, event.getCamera());
            }
        }
    }

    private static void handlePlayerRendering(RenderLevelStageEvent event) {
        RenderLevelStageEvent.Stage stage = event.getStage();
        if (stage == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            for (Player i : mc.level.players()) {
                ((MiscPlayerData)i.getData(MiscPlayerData.ATTACHMENT)).renderAdditional(event);
            }
        }
    }

    private static void onReloadClientResources(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ParticleSpawnerParticlesDataLoader.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)ColorGradingLoader.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)EnvDataLoader.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)new ResourceManagerReloadListener(){

            public void onResourceManagerReload(ResourceManager resourceManager) {
                BiomeSoundInstance.clear();
            }

            public String getName() {
                return "pastel:cache_clearer_client";
            }
        });
    }

    private static void initializeColorGrading(Minecraft client) {
        if (PastelShaders.colorGradingPostProcess.isEmpty()) {
            PastelShaders.colorGradingPostProcess = PastelShaders.loadPostProcess(client, PastelShaders.COLOR_GRADING_ID);
        }
    }

    private static boolean renderPlacementStaffOutline(PoseStack matrices, Camera camera, double d, double e, double f, MultiBufferSource consumers, @NotNull BlockHitResult hitResult) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel world = client.level;
        LocalPlayer player = client.player;
        if (player == null || world == null) {
            return false;
        }
        BlockPos lookingAtPos = hitResult.getBlockPos();
        BlockState lookingAtState = world.getBlockState(lookingAtPos);
        Item item = player.getMainHandItem().getItem();
        if (item instanceof BuildingStaffItem) {
            BuildingStaffItem staff = (BuildingStaffItem)item;
            if (player.isCreative() || staff.canInteractWith(lookingAtState, (BlockGetter)world, lookingAtPos, (Player)player)) {
                Block lookingAtBlock = lookingAtState.getBlock();
                Item item2 = lookingAtBlock.asItem();
                VoxelShape shape = Shapes.empty();
                if (item2 != Items.AIR) {
                    int itemCountInInventory = Integer.MAX_VALUE;
                    long inkLimit = Long.MAX_VALUE;
                    if (!player.isCreative()) {
                        Triplet<Block, Item, Integer> inventoryItemAndCount = BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars((Player)player, lookingAtBlock, Integer.MAX_VALUE);
                        item2 = (Item)inventoryItemAndCount.getB();
                        itemCountInInventory = (Integer)inventoryItemAndCount.getC();
                        inkLimit = InkPowered.getAvailableInk((Player)player, ConstructorsStaffItem.USED_COLOR) / 1L;
                    }
                    boolean sneaking = player.isShiftKeyDown();
                    if (itemCountInInventory == 0) {
                        HudRenderers.setItemStackToRender(new ItemStack((ItemLike)item2), 0, false);
                    } else if (inkLimit == 0L) {
                        HudRenderers.setItemStackToRender(new ItemStack((ItemLike)item2), 1, true);
                    } else {
                        long usableCount = Math.min((long)itemCountInInventory, inkLimit);
                        List<BlockPos> positions = BuildingHelper.calculateBuildingStaffSelection((Level)world, lookingAtPos, hitResult.getDirection(), usableCount, ConstructorsStaffItem.getRange((Player)player), !sneaking);
                        if (!positions.isEmpty()) {
                            for (BlockPos newPosition : positions) {
                                if (!world.getWorldBorder().isWithinBounds(newPosition)) continue;
                                BlockPos testPos = lookingAtPos.subtract((Vec3i)newPosition);
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)lookingAtState.getShape((BlockGetter)world, lookingAtPos, CollisionContext.of((Entity)camera.getEntity())).move((double)(-testPos.getX()), (double)(-testPos.getY()), (double)(-testPos.getZ())));
                            }
                            HudRenderers.setItemStackToRender(new ItemStack((ItemLike)item2), positions.size(), false);
                            VertexConsumer linesBuffer = consumers.getBuffer(RenderType.lines());
                            WorldRendererAccessor.invokeRenderShape(matrices, linesBuffer, shape, (double)lookingAtPos.getX() - d, (double)lookingAtPos.getY() - e, (double)lookingAtPos.getZ() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean renderExchangeStaffOutline(PoseStack matrices, Camera camera, double d, double e, double f, MultiBufferSource consumers, ItemStack exchangeStaffItemStack, BlockHitResult hitResult) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = client.level;
        BlockPos lookingAtPos = hitResult.getBlockPos();
        BlockState lookingAtState = level.getBlockState(lookingAtPos);
        LocalPlayer player = client.player;
        if (player == null) {
            return false;
        }
        Item item = player.getMainHandItem().getItem();
        if (item instanceof BuildingStaffItem) {
            BuildingStaffItem staff = (BuildingStaffItem)item;
            if (player.isCreative() || staff.canInteractWith(lookingAtState, (BlockGetter)level, lookingAtPos, (Player)player)) {
                Block lookingAtBlock = lookingAtState.getBlock();
                Optional<Block> exchangeBlock = ExchangeStaffItem.getStoredBlock(exchangeStaffItemStack);
                if (exchangeBlock.isPresent() && exchangeBlock.get() != lookingAtBlock) {
                    Item exchangeBlockItem = exchangeBlock.get().asItem();
                    VoxelShape shape = Shapes.empty();
                    if (exchangeBlockItem != Items.AIR) {
                        int itemCountInInventory = Integer.MAX_VALUE;
                        long inkLimit = Integer.MAX_VALUE;
                        if (!player.isCreative()) {
                            Inventory playerInventory = player.getInventory();
                            itemCountInInventory = playerInventory.countItem(exchangeBlockItem);
                            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                                ItemStack currentStack = playerInventory.getItem(i);
                                ItemProvider itemProvider = (ItemProvider)currentStack.getCapability(ItemProvider.CAPABILITY);
                                if (itemProvider == null) continue;
                                itemCountInInventory += itemProvider.getItemCount((Player)player, currentStack, exchangeBlockItem);
                            }
                            inkLimit = InkPowered.getAvailableInk((Player)player, ExchangeStaffItem.USED_COLOR) / 5L;
                        }
                        if (itemCountInInventory == 0) {
                            HudRenderers.setItemStackToRender(new ItemStack((ItemLike)exchangeBlockItem), 0, false);
                        } else if (inkLimit == 0L) {
                            HudRenderers.setItemStackToRender(new ItemStack((ItemLike)exchangeBlockItem), 1, true);
                        } else {
                            long usableCount = Math.min((long)itemCountInInventory, inkLimit);
                            List<BlockPos> positions = BuildingHelper.getConnectedBlocks((Level)level, lookingAtPos, usableCount, ExchangeStaffItem.getRange((Player)player));
                            for (BlockPos newPosition : positions) {
                                if (!level.getWorldBorder().isWithinBounds(newPosition)) continue;
                                BlockPos testPos = lookingAtPos.subtract((Vec3i)newPosition);
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)lookingAtState.getShape((BlockGetter)level, lookingAtPos, CollisionContext.of((Entity)camera.getEntity())).move((double)(-testPos.getX()), (double)(-testPos.getY()), (double)(-testPos.getZ())));
                            }
                            HudRenderers.setItemStackToRender(new ItemStack((ItemLike)exchangeBlockItem), positions.size(), false);
                            VertexConsumer linesBuffer = consumers.getBuffer(RenderType.lines());
                            WorldRendererAccessor.invokeRenderShape(matrices, linesBuffer, shape, (double)lookingAtPos.getX() - d, (double)lookingAtPos.getY() - e, (double)lookingAtPos.getZ() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

