/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.api.item.ArmorPiercingHandler;
import earth.terrarium.pastel.api.item.SplitDamageHandler;
import earth.terrarium.pastel.attachments.data.LastKillData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.items.trinkets.AttackRingItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.mixin.accessors.LivingEntityAccessor;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithPatternAndVelocityPayload;
import earth.terrarium.pastel.particle.VectorPattern;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelDamageTypeTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.status_effects.FrenzyStatusEffect;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class PastelDamageEvents {
    private static final int RATE_COOLDOWN = 1;
    private static final Map<UUID, Object2LongArrayMap<UUID>> RATE_LIMITS = new HashMap<UUID, Object2LongArrayMap<UUID>>();
    private static final Set<LivingEntity> RECURSIVE_TARGETS = new HashSet<LivingEntity>();

    public static void register() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelDamageEvents::unblockableBypass);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, PastelDamageEvents::handleUnblockable);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, PastelDamageEvents::splitDamage);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelDamageEvents::rateLimitDamage);
        NeoForge.EVENT_BUS.addListener(PastelDamageEvents::updateRateLimits);
        NeoForge.EVENT_BUS.addListener(PastelDamageEvents::modifyArmorDamage);
        NeoForge.EVENT_BUS.addListener(PastelDamageEvents::handlePiercing);
        NeoForge.EVENT_BUS.addListener(PastelDamageEvents::vulnerability);
        NeoForge.EVENT_BUS.addListener(PastelDamageEvents::handlePuffCirclet);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelDamageEvents::handleDike);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelDamageEvents::applyKillBonuses);
    }

    private static void applyKillBonuses(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (PastelTrinketItem.hasEquipped(attacker, (Item)PastelItems.JEOPARDANT.get())) {
            event.setNewDamage((float)((double)event.getNewDamage() * (AttackRingItem.getAttackModifierForEntity(attacker) + 1.0)));
        }
        LastKillData.rememberKillTick(attacker, entity.level().getGameTime());
        MobEffectInstance frenzy = attacker.getEffect(PastelMobEffects.FRENZY);
        if (frenzy != null) {
            ((FrenzyStatusEffect)((Object)frenzy.getEffect().value())).onKill(attacker, frenzy.getAmplifier());
        }
    }

    private static void rateLimitDamage(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.getEntity();
        if (attacker == null || !source.is(PastelDamageTypeTags.RATE_LIMITED)) {
            return;
        }
        if (event.getContainer().getNewDamage() < 1.0E-5f) {
            return;
        }
        Object2LongArrayMap memory = RATE_LIMITS.computeIfAbsent(attacker.getUUID(), u -> new Object2LongArrayMap());
        if (memory.containsKey((Object)target.getUUID())) {
            event.setCanceled(true);
            return;
        }
        memory.put((Object)target.getUUID(), target.level().getGameTime());
    }

    private static void updateRateLimits(ServerTickEvent.Pre event) {
        long time = event.getServer().getLevel(ServerLevel.OVERWORLD).getGameTime();
        ArrayList<UUID> remove = new ArrayList<UUID>();
        for (UUID uUID : RATE_LIMITS.keySet()) {
            if (!RATE_LIMITS.get(uUID).isEmpty()) continue;
            remove.add(uUID);
        }
        remove.forEach(RATE_LIMITS::remove);
        remove.clear();
        for (Object2LongArrayMap object2LongArrayMap : RATE_LIMITS.values()) {
            for (Object2LongMap.Entry attacked : object2LongArrayMap.object2LongEntrySet()) {
                if (time - attacked.getLongValue() <= 1L) continue;
                remove.add((UUID)attacked.getKey());
            }
            remove.forEach(arg_0 -> ((Object2LongArrayMap)object2LongArrayMap).removeLong(arg_0));
            remove.clear();
        }
    }

    private static void unblockableBypass(EntityInvulnerabilityCheckEvent event) {
        if (event.getSource().is(PastelDamageTypeTags.UNBLOCKABLE)) {
            event.setInvulnerable(false);
        }
    }

    private static void handleUnblockable(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        DamageContainer container = event.getContainer();
        float damage = container.getOriginalDamage();
        DamageSource source = event.getSource();
        if (!source.is(PastelDamageTypeTags.UNBLOCKABLE) || target.isDeadOrDying()) {
            return;
        }
        target.setHealth(target.getHealth() - container.getOriginalDamage());
        if (target.isDeadOrDying()) {
            target.getCombatTracker().recordDamage(source, damage);
            target.die(source);
        }
        event.setCanceled(true);
    }

    private static void handleDike(LivingIncomingDamageEvent event) {
        if (event.getSource().is(PastelDamageTypeTags.BYPASSES_DIKE)) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageContainer container = event.getContainer();
        container.setNewDamage(AzureDikeProvider.absorbDamage(target, container.getNewDamage()));
    }

    private static void splitDamage(LivingIncomingDamageEvent event) {
        LivingEntity attacker;
        int invuln;
        LivingEntity target;
        block8: {
            block7: {
                target = event.getEntity();
                invuln = event.getContainer().getPostAttackInvulnerabilityTicks();
                if (RECURSIVE_TARGETS.contains(target)) {
                    event.getContainer().setPostAttackInvulnerabilityTicks(0);
                    return;
                }
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof LivingEntity)) break block7;
                attacker = (LivingEntity)entity;
                if (!(event.getAmount() <= 1.0E-5f)) break block8;
            }
            return;
        }
        ItemStack weapon = attacker.getMainHandItem();
        if (weapon.isEmpty()) {
            return;
        }
        SplitDamageHandler split = (SplitDamageHandler)weapon.getCapability(PastelCapabilities.Misc.SPLIT_DAMAGE);
        if (split == null) {
            return;
        }
        RECURSIVE_TARGETS.add(target);
        SplitDamageHandler.DamageComposition composition = split.getDamageComposition(attacker, target, weapon, event.getAmount());
        for (SplitDamageHandler.Partition partition : composition.get()) {
            target.hurt(partition.source(), partition.damage());
        }
        RECURSIVE_TARGETS.remove(target);
        event.setAmount(0.0f);
        event.getContainer().setPostAttackInvulnerabilityTicks(invuln);
    }

    private static void vulnerability(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        DamageContainer container = event.getContainer();
        MobEffectInstance vuln = target.getEffect(PastelMobEffects.VULNERABILITY);
        if (vuln == null) {
            return;
        }
        container.setNewDamage(container.getNewDamage() * PastelMobEffects.vulnerabilityMod(vuln));
    }

    private static void modifyArmorDamage(ArmorHurtEvent event) {
        block5: {
            DamageSource source;
            block4: {
                LivingEntity entity = event.getEntity();
                Stack<DamageContainer> containers = ((LivingEntityAccessor)entity).getDamageContainers();
                if (containers == null) {
                    return;
                }
                DamageContainer container = containers.peek();
                if (container == null) {
                    return;
                }
                source = container.getSource();
                if (!source.is(PastelDamageTypeTags.INCREASED_ARMOR_DAMAGE)) break block4;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    event.setNewDamage(slot, event.getNewDamage(slot).floatValue() * 10.0f);
                }
                break block5;
            }
            if (!source.is(PastelDamageTypeTags.DOES_NOT_DAMAGE_ARMOR)) break block5;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                event.setNewDamage(slot, 0.0f);
            }
        }
    }

    private static void handlePuffCirclet(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (!CuriosApi.getCuriosInventory((LivingEntity)entity).map(i -> i.isEquipped(PastelItems.PUFF_CIRCLET.asItem())).orElse(false).booleanValue()) {
            return;
        }
        int damage = ((LivingEntityAccessor)entity).callCalculateFallDamage(event.getDistance(), event.getDamageMultiplier());
        float cost = Math.min((float)damage, 2.0f);
        RandomSource random = entity.getRandom();
        if (cost <= 0.0f || AzureDikeProvider.getAzureDikeCharges(entity) < cost) {
            return;
        }
        AzureDikeProvider.absorbDamage(entity, cost);
        if (!entity.level().isClientSide()) {
            PlayParticleWithPatternAndVelocityPayload.playParticleWithPatternAndVelocity(null, (ServerLevel)entity.level(), entity.position(), ColoredCraftingParticleEffect.WHITE, VectorPattern.EIGHT, 0.4);
            PlayParticleWithPatternAndVelocityPayload.playParticleWithPatternAndVelocity(null, (ServerLevel)entity.level(), entity.position(), ColoredCraftingParticleEffect.BLUE, VectorPattern.EIGHT_OFFSET, 0.5);
        }
        entity.level().playSound(null, entity.blockPosition(), PastelSounds.PUFF_CIRCLET_PFFT, SoundSource.PLAYERS, Support.varFloat(random, 0.2f), Support.varFloatCentered(random, 0.2f));
        event.setCanceled(true);
    }

    private static void handlePiercing(LivingIncomingDamageEvent event) {
        DamageContainer container = event.getContainer();
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack weapon = attacker.getMainHandItem();
        if (weapon.isEmpty()) {
            return;
        }
        Object object = weapon.getCapability(PastelCapabilities.Misc.SPLIT_DAMAGE);
        if (object instanceof ArmorPiercingHandler) {
            ArmorPiercingHandler ap = (ArmorPiercingHandler)object;
            LivingEntity target = event.getEntity();
            container.addModifier(DamageContainer.Reduction.ENCHANTMENTS, (damageContainer, f) -> f * (1.0f - ap.getProtReduction(target, weapon)));
            container.addModifier(DamageContainer.Reduction.ARMOR, (damageContainer, f) -> f * (1.0f - ap.getDefenseMultiplier(target, weapon)));
        }
    }
}

