/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.api.interaction.ResonanceProcessor;
import earth.terrarium.pastel.api.item.ItemPickupListener;
import earth.terrarium.pastel.helpers.enchantments.ExuberanceHelper;
import earth.terrarium.pastel.helpers.enchantments.FoundryHelper;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PastelEnchantmentEvents {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, PastelEnchantmentEvents::applyVoiding);
        NeoForge.EVENT_BUS.addListener(PastelEnchantmentEvents::applyResonance);
        NeoForge.EVENT_BUS.addListener(PastelEnchantmentEvents::applyFoundry);
        NeoForge.EVENT_BUS.addListener(PastelEnchantmentEvents::applyExuberance);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelEnchantmentEvents::inventoryInsertion);
    }

    private static void applyExuberance(BlockDropsEvent event) {
        RegistryAccess access = event.getLevel().registryAccess();
        ItemStack tool = event.getTool();
        event.setDroppedExperience(Math.round((float)event.getDroppedExperience() * ExuberanceHelper.getExuberanceMod(access, tool)));
    }

    private static void inventoryInsertion(BlockDropsEvent event) {
        ItemStack tool = event.getTool();
        Entity breaker = event.getBreaker();
        if (!EnchantmentHelper.hasTag((ItemStack)tool, PastelEnchantmentTags.INVENTORY_INSERTION_EFFECT)) {
            return;
        }
        IItemHandler handler = (IItemHandler)breaker.getCapability(Capabilities.ItemHandler.ENTITY);
        if (handler == null) {
            return;
        }
        ArrayList<ItemEntity> removed = new ArrayList<ItemEntity>();
        for (ItemEntity drop : event.getDrops()) {
            ItemStack stack = drop.getItem();
            ItemStack remainder = PastelEnchantmentEvents.insertStack(breaker, handler, stack);
            if (remainder.isEmpty()) {
                removed.add(drop);
                continue;
            }
            drop.setItem(remainder);
            break;
        }
        removed.forEach(e -> event.getDrops().remove(e));
    }

    private static ItemStack insertStack(Entity taker, IItemHandler inventory, ItemStack stack) {
        ItemStack rem = ItemPickupListener.receiveRecursive(inventory, 2, 0, stack, Optional.ofNullable(taker));
        if (rem.isEmpty()) {
            return rem;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
    }

    private static void applyFoundry(BlockDropsEvent event) {
        ItemStack tool = event.getTool();
        if (!EnchantmentHelper.hasTag((ItemStack)tool, PastelEnchantmentTags.SMELTS_MORE_LOOT)) {
            return;
        }
        PastelEnchantmentEvents.modifyDrops(event, (e, access, stacks) -> FoundryHelper.applyFoundry((Level)e.getLevel(), stacks));
    }

    private static void applyResonance(BlockDropsEvent event) {
        ItemStack tool = event.getTool();
        if (!EnchantmentHelper.hasTag((ItemStack)tool, PastelEnchantmentTags.RESONANT_BLOCK_DROPS)) {
            return;
        }
        PastelEnchantmentEvents.modifyDrops(event, (e, access, stacks) -> {
            ResonanceProcessor.applyResonance(access, event.getState(), event.getBlockEntity(), stacks);
            return stacks;
        });
    }

    private static void applyVoiding(BlockDropsEvent event) {
        ItemStack tool = event.getTool();
        BlockPos pos = event.getPos();
        if (!EnchantmentHelper.hasTag((ItemStack)tool, PastelEnchantmentTags.NO_BLOCK_DROPS)) {
            return;
        }
        event.getDrops().clear();
        event.getLevel().sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.05);
    }

    private static void modifyDrops(BlockDropsEvent event, DropModifier modifier) {
        List entities = event.getDrops();
        ServerLevel level = event.getLevel();
        List<ItemStack> drops = new ArrayList<ItemStack>();
        BlockPos pos = event.getPos();
        for (ItemEntity entity : entities) {
            drops.add(entity.getItem());
        }
        drops = modifier.apply(event, level.registryAccess(), drops);
        entities.clear();
        drops.forEach(d -> entities.add(PastelEnchantmentEvents.createItemEntity(d, pos, level)));
    }

    private static ItemEntity createItemEntity(ItemStack stack, BlockPos pos, ServerLevel level) {
        double d0 = (double)EntityType.ITEM.getHeight() / 2.0;
        double x = (double)pos.getX() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
        double y = (double)pos.getY() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25) - d0;
        double z = (double)pos.getZ() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
        ItemEntity entity = new ItemEntity((Level)level, x, y, z, stack);
        entity.setDefaultPickUpDelay();
        return entity;
    }

    private static interface DropModifier {
        public List<ItemStack> apply(BlockDropsEvent var1, RegistryAccess var2, List<ItemStack> var3);
    }
}

