/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.ArmorWithHitEffect;
import earth.terrarium.pastel.api.item.ItemPickupListener;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.events.PastelEffectEvents;
import earth.terrarium.pastel.events.game.PastelGameEvents;
import earth.terrarium.pastel.helpers.enchantments.DisarmingHelper;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.ParryingSwordItem;
import earth.terrarium.pastel.items.trinkets.AshenCircletItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelAttributeTags;
import earth.terrarium.pastel.registries.PastelDamageTypeTags;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PastelEntityEvents {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::entityTick);
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::allowDamage);
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::equipmentChange);
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::entityDeath);
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::parryingSwordBlock);
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::disarming);
        NeoForge.EVENT_BUS.addListener(PastelEntityEvents::armorEffects);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelEntityEvents::listenItemPickup);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelEntityEvents::listenEntityAdded);
    }

    private static void listenItemPickup(ItemEntityPickupEvent.Pre event) {
        Player entity = event.getPlayer();
        ItemEntity item = event.getItemEntity();
        ItemStack original = item.getItem().copy();
        if (item.hasPickUpDelay()) {
            return;
        }
        ItemPickupListener eListener = (ItemPickupListener)entity.getCapability(PastelCapabilities.Pickup.ENTITY);
        ItemStack remainder = null;
        if (eListener != null && eListener.accepts(Optional.empty(), item.getItem())) {
            remainder = eListener.receive(Optional.empty(), item.getItem(), Optional.of(entity));
        }
        IItemHandler inv = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        if (remainder == null && inv != null) {
            remainder = ItemPickupListener.receiveRecursive(inv, 2, 0, item.getItem(), Optional.of(entity));
        }
        if (remainder == null || ItemStack.isSameItemSameComponents(remainder, (ItemStack)original)) {
            return;
        }
        item.setItem(remainder);
        event.setCanPickup(TriState.FALSE);
        entity.take((Entity)item, original.getCount() - remainder.getCount());
        entity.onItemPickup(item);
    }

    private static void listenEntityAdded(EntityJoinLevelEvent event) {
        if (event.loadedFromDisk()) {
            return;
        }
        Entity entity = event.getEntity();
        entity.gameEvent(PastelGameEvents.ENTITY_SPAWNED);
    }

    private static void armorEffects(LivingDamageEvent.Post event) {
        LivingEntity attacked = event.getEntity();
        if (attacked.level().isClientSide()) {
            return;
        }
        for (ItemStack armor : attacked.getArmorSlots()) {
            Item item = armor.getItem();
            if (!(item instanceof ArmorWithHitEffect)) continue;
            ArmorWithHitEffect effect = (ArmorWithHitEffect)item;
            effect.onHit(armor, event.getSource(), attacked, event.getNewDamage());
        }
    }

    private static void disarming(LivingDamageEvent.Post event) {
        LivingEntity attacker;
        LivingEntity target;
        block5: {
            block4: {
                target = event.getEntity();
                DamageSource source = event.getSource();
                Entity entity = source.getEntity();
                if (!(entity instanceof LivingEntity)) break block4;
                attacker = (LivingEntity)entity;
                if (!(event.getNewDamage() <= 1.0E-5f) && !source.is(DamageTypes.THORNS)) break block5;
            }
            return;
        }
        int disarming = Ench.getLevel((HolderLookup.Provider)attacker.registryAccess(), PastelEnchantments.DISARMING, attacker.getMainHandItem());
        if (disarming > 0 && target.getRandom().nextFloat() < (float)disarming * PastelCommon.CONFIG.DisarmingChancePerLevelMobs) {
            DisarmingHelper.disarmEntity(target);
        }
    }

    private static void parryingSwordBlock(LivingShieldBlockEvent event) {
        Player player;
        float damage = event.getDamageContainer().getOriginalDamage();
        LivingEntity shielder = event.getEntity();
        ItemStack weapon = shielder.getUseItem();
        Item item = weapon.getItem();
        if (!(item instanceof ParryingSwordItem)) {
            return;
        }
        ParryingSwordItem parryingSword = (ParryingSwordItem)item;
        if (event.getDamageSource().is(PastelDamageTypeTags.BYPASSES_PARRYING)) {
            event.setBlocked(false);
            event.setBlockedDamage(0.0f);
            return;
        }
        boolean perfect = false;
        if (!shielder.isBlocking() || !PastelEntityEvents.checkShieldFacing(event.getDamageSource(), event.getEntity(), -0.25)) {
            return;
        }
        int useTime = shielder.getTicksUsingItem();
        if (shielder instanceof Player && parryingSword.canBluffParry(weapon, (LivingEntity)(player = (Player)shielder), useTime)) {
            perfect = parryingSword.canPerfectParry(weapon, (LivingEntity)player, useTime);
            MiscPlayerData misc = MiscPlayerData.get(player);
            misc.setParryTicks(15);
            if (perfect) {
                misc.markForPerfectCounter();
            }
        }
        if (parryingSword.canDeflect(event.getDamageSource(), perfect)) {
            float mult = parryingSword.getBlockingMultiplier(event.getDamageSource(), weapon, shielder, useTime);
            if (mult > 0.0f) {
                shielder.level().broadcastEntityEvent((Entity)shielder, (byte)29);
            }
            event.setBlocked(true);
            event.setBlockedDamage(damage - damage * mult);
        }
    }

    private static void entityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.level().isClientSide()) {
                return;
            }
            List<MobEffectInstance> additions = PastelEffectEvents.QUEUED_ADDITIONS.get(entity.getUUID());
            if (additions != null) {
                additions.forEach(arg_0 -> ((LivingEntity)living).addEffect(arg_0));
                additions.clear();
            }
            PrimordialFireData.serverTick(living);
            AzureDikeProvider.getAzureDikeComponent(living).serverTick(living);
        }
    }

    private static void allowDamage(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (source.is(DamageTypes.LAVA)) {
            Optional<ItemStack> ashenCircletStack = PastelTrinketItem.getFirstEquipped(entity, (Item)PastelItems.ASHEN_CIRCLET.get());
            if (ashenCircletStack.isPresent() && AshenCircletItem.getCooldownTicks(ashenCircletStack.get(), entity.level()) == 0L) {
                AshenCircletItem.grantFireResistance(ashenCircletStack.get(), entity);
                event.setCanceled(true);
            }
        } else if (source.is(DamageTypeTags.IS_FIRE) && PastelTrinketItem.hasEquipped(entity, (Item)PastelItems.ASHEN_CIRCLET.get())) {
            event.setCanceled(true);
        }
    }

    private static void equipmentChange(LivingEquipmentChangeEvent event) {
        TagKey<Attribute> effectType;
        LivingEntity livingEntity = event.getEntity();
        ItemStack oldEquipment = event.getFrom();
        ItemStack newEquipment = event.getTo();
        EquipmentSlot equipmentSlot = event.getSlot();
        int oldInexorable = Ench.getLevel((HolderLookup.Provider)livingEntity.level().registryAccess(), PastelEnchantments.INEXORABLE, oldEquipment);
        int newInexorable = Ench.getLevel((HolderLookup.Provider)livingEntity.level().registryAccess(), PastelEnchantments.INEXORABLE, newEquipment);
        TagKey<Attribute> tagKey = effectType = equipmentSlot == EquipmentSlot.CHEST ? PastelAttributeTags.INEXORABLE_ARMOR_EFFECTIVE : PastelAttributeTags.INEXORABLE_HANDHELD_EFFECTIVE;
        if (oldInexorable > 0 && newInexorable <= 0) {
            livingEntity.getActiveEffects().stream().filter(instance -> {
                AtomicBoolean result = new AtomicBoolean(false);
                ((MobEffect)instance.getEffect().value()).createModifiers(instance.getAmplifier(), (attribute, modifier) -> {
                    if (attribute.is(effectType)) {
                        result.set(true);
                    }
                });
                return result.get();
            }).forEach(instance -> ((MobEffect)instance.getEffect().value()).onEffectStarted(livingEntity, instance.getAmplifier()));
        }
    }

    private static void entityDeath(LivingDeathEvent event) {
        ItemStack totemStack;
        Optional totem;
        LivingEntity killedEntity = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)killedEntity);
        if (curios.isPresent() && (totem = ((ICuriosItemHandler)curios.get()).findFirstCurio((Item)PastelItems.TOTEM_PENDANT.get())).isPresent() && (totemStack = ((SlotResult)totem.get()).stack()).getCount() > 0) {
            if (killedEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)killedEntity;
                serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                CriteriaTriggers.USED_TOTEM.trigger(serverPlayerEntity, totemStack);
            }
            totemStack.shrink(1);
            killedEntity.setHealth(1.0f);
            killedEntity.removeAllEffects();
            killedEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            killedEntity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            killedEntity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            killedEntity.level().broadcastEntityEvent((Entity)killedEntity, (byte)35);
            event.setCanceled(true);
            return;
        }
        if (killedEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)killedEntity;
            PastelEntityEvents.evaluateAndDropPlayerHead(player, damageSource);
        }
    }

    private static void evaluateAndDropPlayerHead(ServerPlayer player, DamageSource source) {
        if (!player.isSpectator()) {
            Entity entity;
            ServerLevel serverWorld = player.serverLevel();
            boolean shouldDropHead = source.is(PastelDamageTypeTags.ALWAYS_DROPS_MOB_HEAD);
            if (!shouldDropHead && (entity = source.getEntity()) instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)entity;
                int damageSourceTreasureHunt = Ench.getEquipmentLevel((HolderLookup.Provider)serverWorld.registryAccess(), PastelEnchantments.TREASURE_HUNTER, livingAttacker);
                boolean bl = shouldDropHead = damageSourceTreasureHunt > 0 && (double)serverWorld.getRandom().nextFloat() < 0.2 * (double)damageSourceTreasureHunt;
            }
            if (shouldDropHead) {
                ItemStack headItemStack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                headItemStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
                ItemEntity headEntity = new ItemEntity((Level)serverWorld, player.getX(), player.getY(), player.getZ(), headItemStack);
                serverWorld.addFreshEntity((Entity)headEntity);
            }
        }
    }

    private static boolean checkShieldFacing(DamageSource damageSource, LivingEntity entity, double leniency) {
        Vec3 vec32 = damageSource.getSourcePosition();
        if (vec32 != null) {
            Vec3 vec3 = entity.calculateViewVector(0.0f, entity.getYHeadRot());
            Vec3 vec31 = vec32.vectorTo(entity.position());
            vec31 = new Vec3(vec31.x, 0.0, vec31.z).normalize();
            return vec31.dot(vec3) < leniency;
        }
        return false;
    }
}

