/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.attachments.data.InertiaData;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelEnchantments;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PastelEquipmentEvents {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, PastelEquipmentEvents::processRazingMod);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, PastelEquipmentEvents::processInertiaMod);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelEquipmentEvents::processInexorable);
    }

    private static void processRazingMod(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntity().getMainHandItem();
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        RegistryAccess access = event.getEntity().registryAccess();
        BlockState state = event.getState();
        if (tool == null) {
            return;
        }
        int razing = Ench.getLevel((HolderLookup.Provider)access, PastelEnchantments.RAZING, stack);
        if (razing > 0 && tool.isCorrectForDrops(state)) {
            float hardness = state.getBlock().defaultDestroyTime();
            event.setNewSpeed((float)Math.max((double)(1.0f + hardness), Math.pow(2.0, 1.0f + (float)razing / 8.0f)));
        }
    }

    private static void processInertiaMod(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntity().getMainHandItem();
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        Player player = event.getEntity();
        Level level = player.level();
        if (tool == null) {
            return;
        }
        RegistryAccess access = event.getEntity().registryAccess();
        BlockState state = event.getState();
        int ench = Ench.getLevel((HolderLookup.Provider)access, PastelEnchantments.INERTIA, stack);
        if (ench > 0 && tool.isCorrectForDrops(state)) {
            float speed = event.getNewSpeed();
            InertiaData inertia = (InertiaData)player.getData(InertiaData.ATTACHMENT);
            float strength = inertia.getPotency(level.isClientSide());
            if (strength > 0.0f) {
                double eff = (double)(strength * strength * (float)ench - 1.0f) / Math.sqrt(1.0 + Math.pow(strength, 2.0));
                event.setNewSpeed(speed * (float)(eff * 3.0 + 4.0));
            } else {
                event.setNewSpeed(speed / 4.0f);
            }
        }
    }

    private static void processInexorable(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntity().getMainHandItem();
        RegistryAccess access = event.getEntity().registryAccess();
        BlockState state = event.getState();
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool == null) {
            return;
        }
        if (Ench.hasEnchantment((HolderLookup.Provider)access, PastelEnchantments.INEXORABLE, stack) && tool.isCorrectForDrops(state)) {
            event.setNewSpeed(Math.max(event.getNewSpeed(), tool.getMiningSpeed(state)));
        }
    }
}

