/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events.listeners;

import earth.terrarium.pastel.events.listeners.EventQueue;
import earth.terrarium.pastel.networking.s2c_payloads.TypedTransmissionPayload;
import earth.terrarium.pastel.particle.effect.TypedTransmission;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class ItemEntityEventQueue
extends EventQueue<EventEntry> {
    public ItemEntityEventQueue(PositionSource positionSource, int range, EventQueue.Callback<EventEntry> listener) {
        super(positionSource, range, listener);
    }

    @Override
    public void acceptEvent(Level world, GameEvent.ListenerInfo event, Vec3 sourcePos) {
        Entity entity;
        if (world instanceof ServerLevel && (entity = event.context().sourceEntity()) instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Vec3 pos = event.source();
            EventEntry eventEntry = new EventEntry((Holder<GameEvent>)event.gameEvent(), itemEntity, Mth.floor((double)pos.distanceTo(sourcePos)));
            int delay = eventEntry.distance * 2;
            this.schedule(eventEntry, delay);
            TypedTransmissionPayload.playTransmissionParticle((ServerLevel)world, new TypedTransmission(pos, this.positionSource, delay, TypedTransmission.Variant.ITEM));
        }
    }

    public static class EventEntry {
        public final Holder<GameEvent> event;
        public final ItemEntity itemEntity;
        public final int distance;

        public EventEntry(Holder<GameEvent> event, ItemEntity itemEntity, int distance) {
            this.event = event;
            this.itemEntity = itemEntity;
            this.distance = distance;
        }
    }
}

