/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.interaction;

import earth.terrarium.pastel.api.interaction.ItemProvider;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.api.item.ItemStorage;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryHelper {
    public static int getItemCountInInventory(IItemHandler inventory, Item item) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!stack.is(item)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static int getStackCountInInventory(IItemHandler inventory, ItemStack reference) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)reference)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static boolean removeFromInventoryWithRemainders(@NotNull Player playerEntity, @NotNull ItemStack stackToRemove) {
        if (playerEntity.isCreative()) {
            return true;
        }
        Inventory playerInventory = playerEntity.getInventory();
        ArrayList<ItemStack> matchingStacks = new ArrayList<ItemStack>();
        int paymentStackItemCount = 0;
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack currentStack = playerInventory.getItem(i);
            ItemProvider itemProvider = (ItemProvider)currentStack.getCapability(ItemProvider.CAPABILITY);
            if (itemProvider == null) {
                if (ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)stackToRemove)) {
                    matchingStacks.add(currentStack);
                    paymentStackItemCount += currentStack.getCount();
                }
            } else {
                matchingStacks.add(currentStack);
                paymentStackItemCount += itemProvider.getItemCount(playerEntity, currentStack, stackToRemove.getItem());
            }
            if (paymentStackItemCount >= stackToRemove.getCount()) break;
        }
        if (paymentStackItemCount < stackToRemove.getCount()) {
            return false;
        }
        int amountToRemove = stackToRemove.getCount();
        for (ItemStack matchingStack : matchingStacks) {
            ItemProvider itemProvider = (ItemProvider)matchingStack.getCapability(ItemProvider.CAPABILITY);
            if (itemProvider != null) {
                amountToRemove -= itemProvider.provideItems(playerEntity, matchingStack, stackToRemove.getItem(), amountToRemove);
                continue;
            }
            int currentRemove = Math.min(matchingStack.getCount(), amountToRemove);
            matchingStack.shrink(currentRemove);
            if ((amountToRemove -= currentRemove) > 0) continue;
            return true;
        }
        return true;
    }

    public static boolean isItemCountInInventory(IItemHandlerModifiable inventory, ItemReference reference, int maxSearchAmount) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!reference.permits(stack) || (count += stack.getCount()) < maxSearchAmount) continue;
            return true;
        }
        return false;
    }

    public static Tuple<Integer, List<ItemStack>> getStackCountInInventory(ItemStack reference, IItemHandlerModifiable inventory, int maxSearchAmount) {
        ArrayList<ItemStack> foundStacks = new ArrayList<ItemStack>();
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)reference)) continue;
            foundStacks.add(stack);
            if ((count += stack.getCount()) < maxSearchAmount) continue;
            return new Tuple((Object)count, foundStacks);
        }
        return new Tuple((Object)count, foundStacks);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ItemStack smartAddToInventory(ItemStack itemStack, IItemHandlerModifiable inventory, @Nullable Direction side) {
        if (inventory instanceof WorldlyContainer) {
            WorldlyContainer sidedInventory = (WorldlyContainer)inventory;
            if (side == null) {
            } else {
                int[] acceptableSlots;
                int[] nArray = acceptableSlots = sidedInventory.getSlotsForFace(side);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int acceptableSlot = nArray[n2];
                    if (sidedInventory.canPlaceItemThroughFace(acceptableSlot, itemStack, side) && (itemStack = InventoryHelper.setOrCombineStack(inventory, acceptableSlot, itemStack)).isEmpty()) {
                        return itemStack;
                    }
                    ++n2;
                }
                return itemStack;
            }
        }
        int i = 0;
        while (i < inventory.getSlots()) {
            if ((itemStack = InventoryHelper.setOrCombineStack(inventory, i, itemStack)).isEmpty()) {
                return itemStack;
            }
            ++i;
        }
        return itemStack;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ItemStack setOrCombineStack(IItemHandlerModifiable inventory, int slot, ItemStack addingStack) {
        ItemStack existingStack = inventory.getStackInSlot(slot);
        if (!existingStack.isEmpty()) {
            InventoryHelper.combineStacks(existingStack, addingStack);
            return addingStack;
        }
        if (addingStack.getCount() > addingStack.getMaxStackSize()) {
            int amount = addingStack.getMaxStackSize();
            amount = Math.min(amount, inventory.getSlotLimit(slot));
            ItemStack newStack = addingStack.copy();
            newStack.setCount(amount);
            addingStack.shrink(amount);
            inventory.setStackInSlot(slot, newStack);
            return addingStack;
        }
        inventory.setStackInSlot(slot, addingStack);
        return ItemStack.EMPTY;
    }

    public static void combineStacks(ItemStack originalStack, ItemStack addingStack) {
        int leftOverAmountInExistingStack;
        if (ItemStack.isSameItemSameComponents((ItemStack)originalStack, (ItemStack)addingStack) && (leftOverAmountInExistingStack = originalStack.getMaxStackSize() - originalStack.getCount()) > 0) {
            int addAmount = Math.min(leftOverAmountInExistingStack, addingStack.getCount());
            originalStack.grow(addAmount);
            addingStack.shrink(addAmount);
        }
    }

    public static boolean addToInventory(IItemHandlerModifiable inventory, ItemStack stackToAdd, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) {
                inventory.setStackInSlot(i, stackToAdd);
                return true;
            }
            if (!stackToAdd.isStackable()) continue;
            InventoryHelper.combineStacks(currentStack, stackToAdd);
            if (!stackToAdd.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean addToInventory(IItemHandlerModifiable inventory, List<ItemStack> stacksToAdd, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack.isEmpty()) {
                inventory.setStackInSlot(i, stacksToAdd.get(0));
                stacksToAdd.removeFirst();
                if (stacksToAdd.isEmpty()) {
                    return true;
                }
            }
            for (int j = 0; j < stacksToAdd.size(); ++j) {
                ItemStack stackToAdd = stacksToAdd.get(j);
                if (!stackToAdd.isStackable()) continue;
                InventoryHelper.combineStacks(inventoryStack, stackToAdd);
                if (!stackToAdd.isEmpty()) continue;
                stacksToAdd.remove(j);
                if (stacksToAdd.isEmpty()) {
                    return true;
                }
                --j;
            }
        }
        return false;
    }

    public static ItemStack offerToInventory(IItemHandlerModifiable inventory, ItemStack itemStack, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) {
                inventory.setStackInSlot(i, itemStack);
                return ItemStack.EMPTY;
            }
            if (!itemStack.isStackable()) continue;
            InventoryHelper.combineStacks(currentStack, itemStack);
            if (!itemStack.isEmpty()) continue;
            return itemStack;
        }
        return itemStack;
    }

    public static boolean hasIngredientStacksInInventory(List<IngredientStack> ingredients, IItemHandlerModifiable inventory) {
        ArrayList<Ingredient> ingredientsToFind = new ArrayList<Ingredient>();
        ArrayList<Integer> requiredIngredientAmounts = new ArrayList<Integer>();
        for (IngredientStack ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ingredientsToFind.add(ingredient.getIngredient());
            requiredIngredientAmounts.add(ingredient.getCount());
        }
        block1: for (int i = 0; i < inventory.getSlots() && !ingredientsToFind.isEmpty(); ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            int amount = currentStack.getCount();
            for (int j = 0; j < ingredientsToFind.size(); ++j) {
                if (!((Ingredient)ingredientsToFind.get(j)).test(currentStack)) continue;
                int ingredientCount = (Integer)requiredIngredientAmounts.get(j);
                if (amount >= ingredientCount) {
                    ingredientsToFind.remove(j);
                    requiredIngredientAmounts.remove(j);
                    --j;
                } else {
                    requiredIngredientAmounts.set(j, (Integer)requiredIngredientAmounts.get(j) - amount);
                }
                if ((amount -= ingredientCount) < 1) continue block1;
            }
        }
        return ingredientsToFind.isEmpty();
    }

    public static boolean hasInInventory(List<Ingredient> ingredients, IItemHandlerModifiable inventory) {
        ArrayList<Ingredient> ingredientsToFind = new ArrayList<Ingredient>();
        ArrayList<Integer> requiredIngredientAmounts = new ArrayList<Integer>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ingredientsToFind.add(ingredient);
            if (ingredient.getItems().length > 0) {
                requiredIngredientAmounts.add(ingredient.getItems()[0].getCount());
                continue;
            }
            requiredIngredientAmounts.add(1);
        }
        block1: for (int i = 0; i < inventory.getSlots() && !ingredientsToFind.isEmpty(); ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            int amount = currentStack.getCount();
            for (int j = 0; j < ingredientsToFind.size(); ++j) {
                if (!((Ingredient)ingredientsToFind.get(j)).test(currentStack)) continue;
                int ingredientCount = (Integer)requiredIngredientAmounts.get(j);
                if (amount >= ingredientCount) {
                    ingredientsToFind.remove(j);
                    requiredIngredientAmounts.remove(j);
                    --j;
                } else {
                    requiredIngredientAmounts.set(j, (Integer)requiredIngredientAmounts.get(j) - amount);
                }
                if ((amount -= ingredientCount) < 1) continue block1;
            }
        }
        return ingredientsToFind.isEmpty();
    }

    public static List<ItemStack> removeFromInventoryWithRemainders(List<Ingredient> ingredients, IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
        ArrayList<Ingredient> requiredIngredients = new ArrayList<Ingredient>();
        ArrayList<Integer> requiredIngredientAmounts = new ArrayList<Integer>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            requiredIngredients.add(ingredient);
            if (ingredient.getItems().length > 0) {
                requiredIngredientAmounts.add(ingredient.getItems()[0].getCount());
                continue;
            }
            requiredIngredientAmounts.add(1);
        }
        for (int i = 0; i < inventory.getSlots() && !requiredIngredients.isEmpty(); ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            for (int j = 0; j < requiredIngredients.size(); ++j) {
                int currentStackCount = currentStack.getCount();
                if (!((Ingredient)requiredIngredients.get(j)).test(currentStack)) continue;
                int ingredientCount = (Integer)requiredIngredientAmounts.get(j);
                ItemStack remainder = currentStack.getCraftingRemainingItem();
                if (currentStackCount >= ingredientCount) {
                    if (!remainder.isEmpty()) {
                        remainder.setCount(((Integer)requiredIngredientAmounts.get(j)).intValue());
                        remainders.add(remainder);
                    }
                    requiredIngredients.remove(j);
                    requiredIngredientAmounts.remove(j);
                    --j;
                } else {
                    if (!remainder.isEmpty()) {
                        remainder.setCount(currentStackCount);
                        remainders.add(remainder);
                    }
                    requiredIngredientAmounts.set(j, (Integer)requiredIngredientAmounts.get(j) - currentStackCount);
                }
                currentStack.setCount(currentStackCount - ingredientCount);
            }
        }
        return remainders;
    }

    public static List<ItemStack> removeIngredientStacksFromInventoryWithRemainders(List<IngredientStack> ingredients, IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
        ArrayList<Ingredient> requiredIngredients = new ArrayList<Ingredient>();
        ArrayList<Integer> requiredIngredientAmounts = new ArrayList<Integer>();
        for (IngredientStack ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            requiredIngredients.add(ingredient.getIngredient());
            requiredIngredientAmounts.add(ingredient.getCount());
        }
        for (int i = 0; i < inventory.getSlots() && !requiredIngredients.isEmpty(); ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            for (int j = 0; j < requiredIngredients.size(); ++j) {
                int currentStackCount = currentStack.getCount();
                if (!((Ingredient)requiredIngredients.get(j)).test(currentStack)) continue;
                int ingredientCount = (Integer)requiredIngredientAmounts.get(j);
                ItemStack remainder = currentStack.getCraftingRemainingItem();
                if (currentStackCount >= ingredientCount) {
                    if (!remainder.isEmpty()) {
                        remainder.setCount(((Integer)requiredIngredientAmounts.get(j)).intValue());
                        remainders.add(remainder);
                    }
                    requiredIngredients.remove(j);
                    requiredIngredientAmounts.remove(j);
                    --j;
                } else {
                    if (!remainder.isEmpty()) {
                        remainder.setCount(currentStackCount);
                        remainders.add(remainder);
                    }
                    requiredIngredientAmounts.set(j, (Integer)requiredIngredientAmounts.get(j) - currentStackCount);
                }
                currentStack.setCount(currentStackCount - ingredientCount);
            }
        }
        return remainders;
    }

    public static boolean canFitStacks(IItemHandlerModifiable inventory, List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return true;
        }
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)true).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static List<ItemStack> getRemainders(List<Ingredient> ingredients) {
        ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty() || ingredient.getItems().length <= 0) continue;
            remainders.add(ingredient.getItems()[0].getCraftingRemainingItem());
        }
        return remainders;
    }

    public static List<ItemStack> removeFromInventoryWithRemainders(ItemStack removeItemStack, IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
        int removeItemStackCount = removeItemStack.getCount();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)removeItemStack)) {
                ItemStack remainder = currentStack.getCraftingRemainingItem();
                int amountAbleToDecrement = Math.min(currentStack.getCount(), removeItemStackCount);
                currentStack.shrink(amountAbleToDecrement);
                removeItemStackCount -= amountAbleToDecrement;
                if (!remainder.isEmpty()) {
                    remainder.setCount(amountAbleToDecrement);
                    remainders.add(remainder);
                }
            }
            if (removeItemStackCount != 0) continue;
            return remainders;
        }
        return remainders;
    }

    public static boolean canCombineItemStacks(ItemStack currentItemStack, ItemStack additionalItemStack) {
        return currentItemStack.isEmpty() || additionalItemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)currentItemStack, (ItemStack)additionalItemStack) && currentItemStack.getCount() + additionalItemStack.getCount() <= currentItemStack.getMaxStackSize();
    }

    public static Optional<ItemStack> extractLastStack(IItemHandlerModifiable inventory) {
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack currentStack = inventory.getStackInSlot(i);
            if (currentStack.isEmpty()) continue;
            inventory.setStackInSlot(i, ItemStack.EMPTY);
            return Optional.of(currentStack);
        }
        return Optional.empty();
    }

    public static ItemStack addToInventoryUpToSingleStackWithMaxTotalCount(ItemStack itemStack, IItemHandlerModifiable inventory, int maxTotalCount) {
        int itemCount = 0;
        int firstEmptySlot = -1;
        ItemStack matchingStack = null;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack slotStack = inventory.getStackInSlot(i);
            if (slotStack.isEmpty()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            itemCount += slotStack.getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)slotStack)) continue;
            matchingStack = slotStack;
        }
        int storageLeft = maxTotalCount - itemCount;
        if (storageLeft <= 0) {
            return itemStack;
        }
        if (matchingStack != null) {
            int addedCount = Math.min(matchingStack.getMaxStackSize() - matchingStack.getCount(), itemStack.getCount());
            if ((addedCount = Math.min(storageLeft, addedCount)) > 0) {
                matchingStack.setCount(matchingStack.getCount() + addedCount);
                itemStack.shrink(addedCount);
            }
            return itemStack;
        }
        if (firstEmptySlot == -1) {
            return itemStack;
        }
        inventory.setStackInSlot(firstEmptySlot, itemStack.split(storageLeft));
        return itemStack;
    }

    public static int countItemsInInventory(IItemHandlerModifiable inventory) {
        int contentCount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            contentCount += inventory.getStackInSlot(i).getCount();
        }
        return contentCount;
    }

    public static ItemStack extractFromInventory(IItemHandler inventory, ItemReference reference, int amount) {
        int extracted = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (reference.permits(inventory.getStackInSlot(i))) {
                extracted += inventory.extractItem(i, amount - extracted, false).getCount();
            }
            if (extracted == amount) break;
        }
        if (extracted == 0) {
            return ItemStack.EMPTY;
        }
        return reference.asStack(extracted);
    }

    public static List<ItemStorage> getAvailableItems(IItemHandler handler) {
        HashMap<ItemReference, ItemStorage> available = new HashMap<ItemReference, ItemStorage>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            ItemReference ref = ItemReference.of(stack);
            if (ref.isEmpty()) continue;
            available.computeIfAbsent(ref, ItemStorage::new).increment(stack.getCount());
        }
        return new ArrayList<ItemStorage>(available.values());
    }
}

