/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.interaction;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TimeHelper {
    public static final long EPOCH_DAY_MILLIS = 86400000L;

    public static TimeOfDay getTimeOfDay(@NotNull Level world) {
        return TimeHelper.getTimeOfDay(world.getDayTime());
    }

    public static TimeOfDay getTimeOfDay(long timeOfDay) {
        long timeMod = timeOfDay % 24000L;
        if (timeMod >= 6000L && timeMod < 7000L) {
            return TimeOfDay.NOON;
        }
        if (timeMod >= 0L && timeMod < 12000L) {
            return TimeOfDay.DAY;
        }
        if (timeMod >= 12000L && timeMod < 13000L) {
            return TimeOfDay.SUNSET;
        }
        if (timeMod >= 23000L) {
            return TimeOfDay.SUNRISE;
        }
        if (timeMod >= 18000L && timeMod < 19000L) {
            return TimeOfDay.MIDNIGHT;
        }
        return TimeOfDay.NIGHT;
    }

    public static boolean isBrightSunlight(Level world) {
        TimeOfDay timeOfDay = TimeHelper.getTimeOfDay(world);
        return timeOfDay.isDay() && !world.isRaining();
    }

    public static long getDay(long time) {
        return time / 24000L % Integer.MAX_VALUE;
    }

    public static float minecraftDaysFromSeconds(long seconds) {
        return (float)seconds / 1200.0f;
    }

    public static long secondsFromMinecraftDays(int minecraftDays) {
        return (long)minecraftDays * 1200L;
    }

    public static enum TimeOfDay implements StringRepresentable
    {
        DAY(0, 12000),
        NIGHT(12000, 24000),
        NOON(6000, 7000),
        SUNSET(12000, 13000),
        MIDNIGHT(18000, 19000),
        SUNRISE(23000, 24000);

        public final int from;
        public final int to;

        private TimeOfDay(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public boolean isNight() {
            return this == NIGHT || this == MIDNIGHT;
        }

        public boolean isDay() {
            return this == DAY || this == NOON;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

