/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.interaction;

import earth.terrarium.pastel.helpers.interaction.CollisionResult;
import earth.terrarium.pastel.helpers.interaction.Orientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VectorCast {
    protected final Vec3 start;
    protected final Vec3 end;
    protected float radius;

    public VectorCast(Vec3 start, Vec3 end, float radius) {
        this.start = start;
        this.end = end;
        this.radius = radius;
    }

    public List<CollisionResult<Entity>> castForEntities(ServerLevel world, Predicate<Entity> preCollisionTestFiltering, Entity ... except) {
        Vec3 ray = this.getRelativeToOrigin(this.end);
        AABB casterBox = new AABB(this.start, this.end).inflate(ray.length() / 2.0);
        List entities = world.getEntitiesOfClass(Entity.class, casterBox, preCollisionTestFiltering);
        List<Entity> exceptSet = Arrays.asList(except);
        return entities.stream().filter(entity -> !exceptSet.contains(entity)).map(entity -> this.processEntity(ray, (Entity)entity, world)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public List<CollisionResult<BlockPos>> castForBlocks(ServerLevel world, Entity except, BiPredicate<ServerLevel, BlockPos> preCollisionTestFiltering) {
        BlockPos blockStart = BlockPos.containing((Position)this.start);
        BlockPos blockEnd = BlockPos.containing((Position)this.end);
        Vec3 ray = this.getRelativeToOrigin(this.end);
        Iterable iterableBlocks = BlockPos.betweenClosed((BlockPos)blockStart, (BlockPos)blockEnd);
        ArrayList<CollisionResult<BlockPos>> collisions = new ArrayList<CollisionResult<BlockPos>>();
        iterableBlocks.forEach(blockPos -> {
            if (!preCollisionTestFiltering.test(world, blockEnd)) {
                return;
            }
            Optional<CollisionResult<BlockPos>> collisionResult = this.processBlock(ray, (BlockPos)blockPos, world);
            collisionResult.ifPresent(collisions::add);
        });
        return collisions;
    }

    private Optional<CollisionResult<Entity>> processEntity(Vec3 ray, Entity entity, ServerLevel world) {
        Vec3 closestPointToIntercept;
        boolean hit = false;
        AABB hitbox = entity.getBoundingBox().inflate((double)this.radius);
        if (hitbox.contains(this.end)) {
            closestPointToIntercept = this.end;
            hit = true;
        } else if (hitbox.contains(this.start)) {
            closestPointToIntercept = this.start;
            hit = true;
        } else {
            Orientation orientation = this.getOrientation();
            Vec3 entityOrigin = this.getRelativeToOrigin(hitbox.getCenter());
            double product = ray.dot(entityOrigin);
            double vectorAngle = Math.acos(product / (ray.length() * entityOrigin.length()));
            double entityOffset = Math.abs(Math.cos(vectorAngle) * entityOrigin.length());
            closestPointToIntercept = new Vec3(entityOffset * Math.sin(orientation.getLongitude()) * Math.cos(orientation.getLatitude()) + this.start.x, entityOffset * Math.sin(orientation.getLongitude()) * Math.sin(orientation.getLatitude()) + this.start.y, entityOffset * Math.cos(orientation.getLongitude()) + this.start.z);
            hit = hitbox.contains(closestPointToIntercept);
        }
        if (hit) {
            return Optional.of(new CollisionResult<Entity>((Level)world, entity, entity instanceof LivingEntity ? CollisionResult.CollisionType.LIVING : CollisionResult.CollisionType.NON_LIVING, closestPointToIntercept));
        }
        return Optional.empty();
    }

    private Optional<CollisionResult<BlockPos>> processBlock(Vec3 ray, BlockPos pos, ServerLevel world) {
        Vec3 closestPointToIntercept;
        boolean hit = false;
        if (this.blockContains(pos, this.end)) {
            closestPointToIntercept = this.end;
            hit = true;
        } else if (this.blockContains(pos, this.start)) {
            closestPointToIntercept = this.start;
            hit = true;
        } else {
            Orientation orientation = this.getOrientation();
            Vec3 blockCenter = this.getRelativeToOrigin(Vec3.atCenterOf((Vec3i)pos));
            double product = ray.dot(blockCenter);
            double vectorAngle = Math.acos(product / (ray.length() * blockCenter.length()));
            double entityOffset = Math.cos(vectorAngle) * blockCenter.length();
            closestPointToIntercept = new Vec3(entityOffset * Math.sin(orientation.getLatitude()) * Math.cos(orientation.getLongitude()) + this.start.x, entityOffset * Math.sin(orientation.getLatitude()) * Math.sin(orientation.getLongitude()) + this.start.y, entityOffset * Math.cos(orientation.getLatitude()) + this.start.z);
            hit = this.blockContains(pos, closestPointToIntercept);
        }
        if (hit) {
            return Optional.of(new CollisionResult<BlockPos>((Level)world, pos, CollisionResult.CollisionType.BLOCK, closestPointToIntercept));
        }
        return Optional.empty();
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean blockContains(BlockPos pos, Vec3 point) {
        return (double)((float)pos.getX() - this.radius) <= point.x() && point.x() <= (double)((float)(pos.getX() + 1) + this.radius) && (double)((float)pos.getY() - this.radius) <= point.y() && point.y() <= (double)((float)(pos.getY() + 1) + this.radius) && (double)((float)pos.getZ() - this.radius) <= point.z() && point.z() <= (double)((float)(pos.getZ() + 1) + this.radius);
    }

    public Orientation getOrientation() {
        Vec3 vector = this.getRelativeToOrigin(this.end);
        return Orientation.fromVector(vector);
    }

    public Vec3 getRelativeToOrigin(Vec3 vector) {
        return vector.subtract(this.start);
    }
}

