/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import earth.terrarium.pastel.mixin.accessors.FoxEntityAccessor;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;

public class EntityHelper {
    public static void addPlayerTrust(Entity entity, Player player) {
        EntityHelper.addPlayerTrust(entity, player.getUUID());
    }

    public static void addPlayerTrust(Entity entity, UUID playerUUID) {
        if (entity instanceof AbstractHorse) {
            AbstractHorse horseBaseEntity = (AbstractHorse)entity;
            if (horseBaseEntity.getOwnerUUID() == null) {
                horseBaseEntity.setOwnerUUID(playerUUID);
            }
        } else if (entity instanceof Fox) {
            Fox foxEntity = (Fox)entity;
            ((FoxEntityAccessor)foxEntity).invokeAddTrustedUuid(playerUUID);
        }
    }

    public static boolean isRealPlayer(Entity entity) {
        return entity instanceof Player && entity.getClass().getCanonicalName().startsWith("net.minecraft");
    }

    public static boolean isRealPlayerProjectileOrPet(Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tameableEntity = (TamableAnimal)entity;
            LivingEntity owner = tameableEntity.getOwner();
            return EntityHelper.isRealPlayer((Entity)owner);
        }
        if (entity instanceof Projectile) {
            Projectile projectileEntity = (Projectile)entity;
            Entity owner = projectileEntity.getOwner();
            return EntityHelper.isRealPlayer(owner);
        }
        return EntityHelper.isRealPlayer(entity);
    }
}

