/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoreHelper {
    @NotNull
    public static List<Component> getLoreTextArrayFromString(@NotNull String string) {
        ArrayList<Component> loreText = new ArrayList<Component>();
        for (String split : string.split("\\\\n")) {
            loreText.addFirst((Component)Component.literal((String)split));
        }
        return loreText;
    }

    @NotNull
    public static String getStringFromLoreTextArray(@NotNull List<Component> lore) {
        if (lore.isEmpty()) {
            return "";
        }
        StringBuilder loreString = new StringBuilder();
        for (int i = 0; i < lore.size(); ++i) {
            loreString.append(lore.get(i).getString());
            if (i == lore.size() - 1) continue;
            loreString.append("\\n");
        }
        return loreString.toString();
    }

    public static void setLore(@NotNull ItemStack itemStack, @Nullable List<Component> lore) {
        if (lore == null || lore.isEmpty()) {
            itemStack.remove(DataComponents.LORE);
        } else {
            ItemLore component = new ItemLore(lore);
            itemStack.set(DataComponents.LORE, (Object)component);
        }
    }

    public static void setLore(@NotNull ItemStack stack, @Nullable Component lore) {
        if (lore == null) {
            stack.remove(DataComponents.LORE);
        } else {
            ItemLore component = new ItemLore(List.of(lore));
            stack.set(DataComponents.LORE, (Object)component);
        }
    }

    public static void removeLore(@NotNull ItemStack itemStack) {
        itemStack.remove(DataComponents.LORE);
    }

    public static boolean hasLore(@NotNull ItemStack itemStack) {
        return itemStack.get(DataComponents.LORE) == null;
    }

    @NotNull
    public static List<Component> getLoreList(@NotNull ItemStack itemStack) {
        ItemLore component = (ItemLore)itemStack.get(DataComponents.LORE);
        if (component == null) {
            return new ArrayList<Component>();
        }
        return component.lines();
    }

    public static boolean equalsLore(List<Component> lore, ItemStack stack) {
        if (LoreHelper.hasLore(stack)) {
            ItemLore component = (ItemLore)stack.get(DataComponents.LORE);
            if (component == null) {
                return lore.isEmpty();
            }
            return component.lines().equals(lore);
        }
        return false;
    }
}

