/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.blocks.chests.BlackHoleChestBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.ShadowSlot;
import earth.terrarium.pastel.inventories.slots.StackFilterSlot;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BlackHoleChestScreenHandler
extends AbstractContainerMenu {
    protected static final int ROWS = 3;
    protected final Level world;
    protected BlackHoleChestBlockEntity blockEntity;
    protected Container filterInventory;

    public BlackHoleChestScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (FilterConfigurable.ExtendedDataWithPos)FilterConfigurable.ExtendedDataWithPos.STREAM_CODEC.decode((Object)buf));
    }

    public BlackHoleChestScreenHandler(int syncId, Inventory playerInventory, FilterConfigurable.ExtendedDataWithPos data) {
        this(syncId, playerInventory, (BlackHoleChestBlockEntity)playerInventory.player.level().getBlockEntity(data.pos(), (BlockEntityType)PastelBlockEntities.BLACK_HOLE_CHEST.get()).orElseThrow(), data.data());
    }

    public BlackHoleChestScreenHandler(int syncId, Inventory playerInventory, BlackHoleChestBlockEntity blockEntity, FilterConfigurable.ExtendedData data) {
        super(PastelScreenHandlerTypes.BLACK_HOLE_CHEST, syncId);
        int k;
        int j;
        this.world = playerInventory.player.level();
        this.filterInventory = FilterConfigurable.getFilterInventoryFromExtendedData(syncId, playerInventory, data, this);
        this.blockEntity = blockEntity;
        BlackHoleChestScreenHandler.checkContainerSize((Container)blockEntity, (int)28);
        blockEntity.startOpen(playerInventory.player);
        int i = -18;
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)blockEntity, k + j * 9, 8 + k * 18, 42 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 131 + j * 18 + i));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 189 + i));
        }
        this.addSlot(new StackFilterSlot((Container)blockEntity, 27, 152, 18, (Item)PastelItems.KNOWLEDGE_GEM.get()));
        for (k = 0; k < 5; ++k) {
            this.addSlot(new BlackHoleChestFilterSlot(this.filterInventory, k, 8 + k * 23, 18));
        }
    }

    public boolean stillValid(Player player) {
        return this.blockEntity.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 27 ? !this.moveItemStackTo(itemStack2, 27, this.slots.size() - 6, true) : !this.moveItemStackTo(itemStack2, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public Container getInventory() {
        return this.blockEntity;
    }

    public void removed(Player player) {
        super.removed(player);
        this.blockEntity.stopOpen(player);
    }

    protected class BlackHoleChestFilterSlot
    extends ShadowSlot {
        public BlackHoleChestFilterSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        @Override
        public boolean onClicked(ItemStack heldStack, ClickAction type, Player player) {
            if (BlackHoleChestScreenHandler.this.blockEntity != null) {
                BlackHoleChestScreenHandler.this.blockEntity.setFilterItem(this.getContainerSlot(), heldStack.copyWithCount(1));
            }
            return super.onClicked(heldStack, type, player);
        }
    }
}

