/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.blocks.cinderhearth.CinderhearthBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.ExperienceStorageItemSlot;
import earth.terrarium.pastel.inventories.slots.InkInputSlot;
import earth.terrarium.pastel.networking.s2c_payloads.UpdateBlockEntityInkPayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CinderhearthScreenHandler
extends AbstractContainerMenu {
    public static final int PLAYER_INVENTORY_START_X = 8;
    public static final int PLAYER_INVENTORY_START_Y = 84;
    protected final Level world;
    private final CinderhearthBlockEntity blockEntity;
    private final ContainerData propertyDelegate;
    public final ServerPlayer player;

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.player != null && this.blockEntity.getInkDirty()) {
            UpdateBlockEntityInkPayload.updateBlockEntityInk(this.blockEntity.getBlockPos(), this.blockEntity.getEnergyStorage(), this.player);
        }
    }

    public CinderhearthScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (CinderhearthBlockEntity)playerInventory.player.level().getBlockEntity((BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf), (BlockEntityType)PastelBlockEntities.CINDERHEARTH.get()).orElseThrow(), (ContainerData)new SimpleContainerData(2));
    }

    public CinderhearthScreenHandler(int syncId, Inventory playerInventory, CinderhearthBlockEntity blockEntity, ContainerData propertyDelegate) {
        super(PastelScreenHandlerTypes.CINDERHEARTH, syncId);
        int j;
        int i;
        ServerPlayer serverPlayerEntity;
        Player player = playerInventory.player;
        this.player = player instanceof ServerPlayer ? (serverPlayerEntity = (ServerPlayer)player) : null;
        this.world = playerInventory.player.level();
        this.propertyDelegate = propertyDelegate;
        this.blockEntity = blockEntity;
        this.addSlot(new InkInputSlot((Container)blockEntity, 1, 146, 13));
        this.addSlot(new ExperienceStorageItemSlot((Container)blockEntity, 2, 38, 52));
        this.addSlot(new Slot((Container)blockEntity, 0, 14, 28));
        for (i = 0; i < 4; ++i) {
            this.addSlot(new Slot((Container)blockEntity, 3 + i, 62 + i * 18, 28));
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot(new Slot((Container)blockEntity, 7 + i, 62 + i * 18, 46));
        }
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 142));
        }
        if (this.player != null) {
            UpdateBlockEntityInkPayload.updateBlockEntityInk(blockEntity.getBlockPos(), this.blockEntity.getEnergyStorage(), this.player);
        }
        this.addDataSlots(propertyDelegate);
    }

    public CinderhearthBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 11 ? !this.moveItemStackTo(itemStack2, 11, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, 11, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public int getCraftingTime() {
        return this.propertyDelegate.get(0);
    }

    public int getCraftingTimeTotal() {
        return this.propertyDelegate.get(1);
    }
}

