/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.api.block.InkColorSelectedPacketReceiver;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.ColorPickerInputSlot;
import earth.terrarium.pastel.inventories.slots.InkStorageSlot;
import earth.terrarium.pastel.networking.s2c_payloads.UpdateBlockEntityInkPayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelRegistryKeys;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ColorPickerScreenHandler
extends AbstractContainerMenu
implements InkColorSelectedPacketReceiver {
    public static final int PLAYER_INVENTORY_START_X = 8;
    public static final int PLAYER_INVENTORY_START_Y = 84;
    protected final Level world;
    public final ServerPlayer player;
    protected ColorPickerBlockEntity blockEntity;

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.player != null && this.blockEntity.getInkDirty()) {
            UpdateBlockEntityInkPayload.updateBlockEntityInk(this.blockEntity.getBlockPos(), this.blockEntity.getEnergyStorage(), this.player);
        }
    }

    public ColorPickerScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (ScreenOpeningData)ScreenOpeningData.STREAM_CODEC.decode((Object)buf));
    }

    public ColorPickerScreenHandler(int syncId, Inventory playerInventory, ScreenOpeningData data) {
        this(syncId, playerInventory, (ColorPickerBlockEntity)playerInventory.player.level().getBlockEntity(data.pos(), (BlockEntityType)PastelBlockEntities.COLOR_PICKER.get()).orElseThrow(), data.inkColor());
    }

    public ColorPickerScreenHandler(int syncId, Inventory playerInventory, ColorPickerBlockEntity blockEntity, Optional<Holder<InkColor>> selectedColor) {
        super(PastelScreenHandlerTypes.COLOR_PICKER, syncId);
        int j;
        ServerPlayer serverPlayerEntity;
        Player player = playerInventory.player;
        this.player = player instanceof ServerPlayer ? (serverPlayerEntity = (ServerPlayer)player) : null;
        this.world = playerInventory.player.level();
        this.blockEntity = blockEntity;
        this.blockEntity.setSelectedColor(selectedColor);
        ColorPickerScreenHandler.checkContainerSize((Container)blockEntity, (int)2);
        blockEntity.startOpen(playerInventory.player);
        this.addSlot(new ColorPickerInputSlot(blockEntity, 0, 26, 33));
        this.addSlot(new InkStorageSlot(blockEntity, 1, 133, 33));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 142));
        }
        if (this.player != null) {
            UpdateBlockEntityInkPayload.updateBlockEntityInk(blockEntity.getBlockPos(), this.blockEntity.getEnergyStorage(), this.player);
        }
    }

    public ColorPickerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean stillValid(Player player) {
        return this.blockEntity.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.blockEntity.stopOpen(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 2 ? !this.moveItemStackTo(itemStack2, 2, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, 2, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    @Override
    public void onInkColorSelectedPacket(Optional<Holder<InkColor>> inkColor) {
        this.blockEntity.setSelectedColor(inkColor);
    }

    public record ScreenOpeningData(BlockPos pos, Optional<Holder<InkColor>> inkColor) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ScreenOpeningData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ScreenOpeningData::pos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderRegistry(PastelRegistryKeys.INK_COLOR)), ScreenOpeningData::inkColor, ScreenOpeningData::new);
    }
}

