/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.blocks.chests.FabricationChestBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.ExtractOnlySlot;
import earth.terrarium.pastel.inventories.slots.StackFilterSlot;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FabricationChestScreenHandler
extends AbstractContainerMenu {
    protected final Level world;
    private final Container inventory;

    public FabricationChestScreenHandler(int syncId, Inventory playerInventory) {
        this(PastelScreenHandlerTypes.FABRICATION_CHEST, syncId, playerInventory);
    }

    protected FabricationChestScreenHandler(MenuType<?> type, int i, Inventory playerInventory) {
        this(type, i, playerInventory, (Container)new SimpleContainer(FabricationChestBlockEntity.INVENTORY_SIZE));
    }

    public FabricationChestScreenHandler(int syncId, Inventory playerInventory, Container inventory) {
        this(PastelScreenHandlerTypes.FABRICATION_CHEST, syncId, playerInventory, inventory);
    }

    protected FabricationChestScreenHandler(MenuType<?> type, int syncId, Inventory playerInventory, Container inventory) {
        super(type, syncId);
        int slotId;
        int j;
        int k;
        int l;
        this.inventory = inventory;
        this.world = playerInventory.player.level();
        FabricationChestScreenHandler.checkContainerSize((Container)inventory, (int)FabricationChestBlockEntity.INVENTORY_SIZE);
        inventory.startOpen(playerInventory.player);
        for (l = 0; l < 3; ++l) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot(inventory, l * 9 + k, 8 + k * 18, 67 + l * 18));
            }
        }
        for (j = 0; j < 4; ++j) {
            slotId = FabricationChestBlockEntity.RECIPE_SLOTS[j];
            this.addSlot(new StackFilterSlot(inventory, slotId, 26 + j * 36, 18, (Item)PastelItems.CRAFTING_TABLET.get()));
        }
        for (j = 0; j < 4; ++j) {
            slotId = FabricationChestBlockEntity.RESULT_SLOTS[j];
            this.addSlot(new ExtractOnlySlot(inventory, slotId, 26 + j * 36, 42));
        }
        for (l = 0; l < 3; ++l) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + l * 9 + 9, 8 + k * 18, 138 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 8 + l * 18, 196));
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack clickedStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack clickedStack = slot.getItem();
            clickedStackCopy = clickedStack.copy();
            if (index < FabricationChestBlockEntity.INVENTORY_SIZE ? !this.moveItemStackTo(clickedStack, 35, 71, false) : index > FabricationChestBlockEntity.INVENTORY_SIZE && clickedStackCopy.is((Item)PastelItems.CRAFTING_TABLET.get()) && !this.moveItemStackTo(clickedStack, FabricationChestBlockEntity.RECIPE_SLOTS[0], FabricationChestBlockEntity.RECIPE_SLOTS[FabricationChestBlockEntity.RECIPE_SLOTS.length - 1] + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(clickedStack, 0, FabricationChestBlockEntity.CHEST_SLOTS.length - 1, false)) {
                return ItemStack.EMPTY;
            }
            if (clickedStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (clickedStack.getCount() == clickedStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, clickedStack);
        }
        return clickedStackCopy;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }
}

