/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.FilteringScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class FilteringScreen
extends AbstractContainerScreen<FilteringScreenHandler> {
    public static final ResourceLocation BACKGROUND = PastelCommon.locate("textures/gui/container/filter.png");
    public static final int STRIP_OFFSET = 144;
    public static final int STRIP_HEIGHT = 16;
    public static final int PLAYER_OFFSET = 55;
    public static final int PLAYER_HEIGHT = 89;
    public static final int BASE_FILTER_HEIGHT = 44;
    private final int rows;

    public FilteringScreen(FilteringScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.rows = handler.getRows() - 1;
        this.imageHeight = 133 + (int)Math.round((double)this.rows * 1.5) * 16;
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 6;
        Component title = this.title;
        int inventoryX = 8;
        int intInventoryY = 41 + (int)Math.round((double)this.rows * 1.5) * 16;
        drawContext.drawString(this.font, title, titleX, titleY, 0x323232, false);
        drawContext.drawString(this.font, this.playerInventoryTitle, inventoryX, intInventoryY, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int i;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        drawContext.blit(BACKGROUND, x, y, 0, 0, this.imageWidth, 44);
        int drawRows = (int)Math.round((double)this.rows * 1.5);
        for (i = 0; i < drawRows; ++i) {
            drawContext.blit(BACKGROUND, x, y + 44 + i * 16, 0, 144, this.imageWidth, 16);
        }
        drawContext.blit(BACKGROUND, x, y + 44 + drawRows * 16, 0, 55, this.imageWidth, 89);
        for (i = 0; i < Math.min(((FilteringScreenHandler)this.menu).filterInventory.getContainerSize(), ((FilteringScreenHandler)this.menu).drawnSlots); ++i) {
            Slot s = ((FilteringScreenHandler)this.menu).getSlot(i);
            drawContext.blit(BACKGROUND, x + s.x - 1, y + s.y - 1, 176, 0, 18, 18);
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }
}

