/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.inventories.QuickNavigationGridScreen;
import earth.terrarium.pastel.inventories.WorkstaffScreenHandler;
import earth.terrarium.pastel.items.tools.GlassCrestWorkstaffItem;
import earth.terrarium.pastel.items.tools.WorkstaffItem;
import earth.terrarium.pastel.networking.c2s_payloads.WorkstaffToggleSelectedPayload;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class WorkstaffScreen
extends QuickNavigationGridScreen<WorkstaffScreenHandler> {
    private static final QuickNavigationGridScreen.Grid RANGE_GRID = new QuickNavigationGridScreen.Grid(QuickNavigationGridScreen.GridEntry.EMPTY, QuickNavigationGridScreen.GridEntry.text((Component)Component.literal((String)"1x1"), (Component)Component.translatable((String)"item.pastel.workstaff.gui.1x1"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_1x1)), QuickNavigationGridScreen.GridEntry.text((Component)Component.literal((String)"5x5"), (Component)Component.translatable((String)"item.pastel.workstaff.gui.5x5"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_5x5)), QuickNavigationGridScreen.GridEntry.BACK, QuickNavigationGridScreen.GridEntry.text((Component)Component.literal((String)"3x3"), (Component)Component.translatable((String)"item.pastel.workstaff.gui.3x3"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_3x3)));
    private static final QuickNavigationGridScreen.Grid ENCHANTMENT_GRID = new QuickNavigationGridScreen.Grid(QuickNavigationGridScreen.GridEntry.EMPTY, QuickNavigationGridScreen.GridEntry.item(Items.FEATHER, (Component)Component.translatable((String)"item.pastel.workstaff.gui.silk_touch"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_SILK_TOUCH)), QuickNavigationGridScreen.GridEntry.BACK, QuickNavigationGridScreen.GridEntry.item((Item)PastelItems.RESONANCE_SHARD.get(), (Component)Component.translatable((String)"item.pastel.workstaff.gui.resonance"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_RESONANCE)), QuickNavigationGridScreen.GridEntry.item(((Block)PastelBlocks.FOUR_LEAF_CLOVER.get()).asItem(), (Component)Component.translatable((String)"item.pastel.workstaff.gui.fortune"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_FORTUNE)));

    public WorkstaffScreen(WorkstaffScreenHandler handler, Inventory playerInventory, Component title) {
        super(handler, playerInventory, title);
        WorkstaffItem workstaffItem;
        ItemStack mainHandStack = playerInventory.player.getMainHandItem();
        Item item = mainHandStack.getItem();
        QuickNavigationGridScreen.GridEntry rightClickGridEntry = item instanceof WorkstaffItem && (workstaffItem = (WorkstaffItem)item).itemAbilitiesEnabled(mainHandStack) ? QuickNavigationGridScreen.GridEntry.item(Items.WOODEN_HOE, (Component)Component.translatable((String)"item.pastel.workstaff.gui.disable_right_click_actions"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.DISABLE_RIGHT_CLICK_ACTIONS)) : QuickNavigationGridScreen.GridEntry.item((Item)PastelItems.MULTITOOL.get(), (Component)Component.translatable((String)"item.pastel.workstaff.gui.enable_right_click_actions"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.ENABLE_RIGHT_CLICK_ACTIONS));
        if (mainHandStack.getItem() instanceof GlassCrestWorkstaffItem) {
            QuickNavigationGridScreen.GridEntry projectileEntry = GlassCrestWorkstaffItem.canShoot(mainHandStack) ? QuickNavigationGridScreen.GridEntry.item(Items.SPECTRAL_ARROW, (Component)Component.translatable((String)"item.pastel.workstaff.gui.disable_projectiles"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.DISABLE_PROJECTILES)) : QuickNavigationGridScreen.GridEntry.item(Items.ARROW, (Component)Component.translatable((String)"item.pastel.workstaff.gui.enable_projectiles"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.ENABLE_PROJECTILES));
            this.gridStack.push(new QuickNavigationGridScreen.Grid(QuickNavigationGridScreen.GridEntry.CLOSE, QuickNavigationGridScreen.GridEntry.item(Items.STONE, (Component)Component.translatable((String)"item.pastel.workstaff.gui.range_group"), screen -> this.selectGrid(RANGE_GRID)), rightClickGridEntry, projectileEntry, QuickNavigationGridScreen.GridEntry.item(Items.ENCHANTED_BOOK, (Component)Component.translatable((String)"item.pastel.workstaff.gui.enchantment_group"), screen -> screen.selectGrid(ENCHANTMENT_GRID))));
        } else {
            RegistryAccess drm = Minecraft.getInstance().player.registryAccess();
            QuickNavigationGridScreen.GridEntry enchantmentEntry = Ench.hasEnchantment((HolderLookup.Provider)drm, (ResourceKey<Enchantment>)Enchantments.FORTUNE, mainHandStack) ? QuickNavigationGridScreen.GridEntry.item(Items.FEATHER, (Component)Component.translatable((String)"item.pastel.workstaff.gui.silk_touch"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_SILK_TOUCH)) : QuickNavigationGridScreen.GridEntry.item(((Block)PastelBlocks.FOUR_LEAF_CLOVER.get()).asItem(), (Component)Component.translatable((String)"item.pastel.workstaff.gui.fortune"), screen -> WorkstaffScreen.select(WorkstaffItem.GUIToggle.SELECT_FORTUNE));
            this.gridStack.push(new QuickNavigationGridScreen.Grid(QuickNavigationGridScreen.GridEntry.CLOSE, QuickNavigationGridScreen.GridEntry.item(Items.STONE, (Component)Component.translatable((String)"item.pastel.workstaff.gui.range_group"), screen -> screen.selectGrid(RANGE_GRID)), rightClickGridEntry, QuickNavigationGridScreen.GridEntry.EMPTY, enchantmentEntry));
        }
    }

    protected static void select(WorkstaffItem.GUIToggle toggle) {
        PacketDistributor.sendToServer((CustomPacketPayload)new WorkstaffToggleSelectedPayload(toggle.ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft client = Minecraft.getInstance();
        client.level.playSound(null, client.player.blockPosition(), PastelSounds.PAINTBRUSH_SELECT, SoundSource.NEUTRAL, 0.6f, 1.0f);
        client.player.closeContainer();
    }
}

