/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories.widgets;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntity;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ColorSelectionWidget
extends AbstractWidget {
    protected final ColorPickerBlockEntity colorPicker;
    @Nullable
    private Consumer<Optional<Holder<InkColor>>> changedListener;
    protected final Screen screen;
    final List<Tuple<InkColor, Boolean>> usableColors = new ArrayList<Tuple<InkColor, Boolean>>();
    final int selectedDotX;
    final int selectedDotY;

    public ColorSelectionWidget(int x, int y, int selectedDotX, int selectedDotY, Screen screen, ColorPickerBlockEntity colorPicker) {
        this(x, y, selectedDotX, selectedDotY, screen, colorPicker, InkColors.BUILTIN_COLORS);
    }

    public ColorSelectionWidget(int x, int y, int selectedDotX, int selectedDotY, Screen screen, ColorPickerBlockEntity colorPicker, List<InkColor> availableColors) {
        super(x, y, 56, 14, (Component)Component.literal((String)""));
        this.colorPicker = colorPicker;
        this.selectedDotX = selectedDotX;
        this.selectedDotY = selectedDotY;
        this.screen = screen;
        for (InkColor inkColor : availableColors) {
            this.usableColors.add((Tuple<InkColor, Boolean>)new Tuple((Object)inkColor, (Object)DatabankUtils.hasAdvancementClient((ResourceLocation)inkColor.getRequiredAdvancement())));
        }
    }

    public void setChangedListener(@Nullable Consumer<Optional<Holder<InkColor>>> changedListener) {
        this.changedListener = changedListener;
    }

    private void onChanged(Optional<Holder<InkColor>> newColor) {
        if (this.changedListener != null) {
            this.changedListener.accept(newColor);
        }
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int i = -1;
        int currentX = this.getX() + 1;
        int currentY = this.getY() + 1;
        for (Tuple<InkColor, Boolean> color : this.usableColors) {
            if (((Boolean)color.getB()).booleanValue()) {
                RenderHelper.fillQuad(context.pose(), currentX, currentY, 5, 5, ((InkColor)color.getA()).getColorVec());
            }
            currentX += 7;
            if (++i != 7) continue;
            currentY += 7;
            currentX = this.getX() + 1;
        }
        this.colorPicker.getSelectedColor().ifPresent(inkColor -> RenderHelper.fillQuad(context.pose(), this.selectedDotX, this.selectedDotY, 4, 4, ((InkColor)inkColor.value()).getColorVec()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean colorSelectionClicked;
        Minecraft client = Minecraft.getInstance();
        if (this.isUnselection(mouseX, mouseY)) {
            client.player.playSound(PastelSounds.BUTTON_CLICK, 1.0f, 1.0f);
            this.onChanged(Optional.empty());
        }
        boolean bl = colorSelectionClicked = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        if (colorSelectionClicked && button == 0) {
            int yOffset;
            int verticalColorOffset;
            int xOffset = Mth.floor((double)mouseX) - this.getX();
            int horizontalColorOffset = xOffset / 7;
            int newColorIndex = horizontalColorOffset + (verticalColorOffset = (yOffset = Mth.floor((double)mouseY) - this.getY()) / 7) * 8;
            Tuple<InkColor, Boolean> clickedColor = this.usableColors.get(newColorIndex);
            if (((Boolean)clickedColor.getB()).booleanValue()) {
                client.player.playSound(PastelSounds.BUTTON_CLICK, 1.0f, 1.0f);
                this.onChanged(Optional.of(PastelRegistries.INK_COLOR.wrapAsHolder((Object)((InkColor)clickedColor.getA()))));
            } else {
                client.player.playSound(PastelSounds.USE_FAIL, 1.0f, 1.0f);
                this.onChanged(Optional.empty());
            }
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"pastel.narration.color_selection", (Object[])new Object[]{this.colorPicker.getSelectedColor()}));
    }

    private boolean isUnselection(double mouseX, double mouseY) {
        return mouseX >= (double)this.selectedDotX && mouseX < (double)(this.selectedDotX + 4) && mouseY >= (double)this.selectedDotY && mouseY < (double)(this.selectedDotY + 4);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) || this.active && this.visible && this.isUnselection(mouseX, mouseY);
    }

    public void drawMouseoverTooltip(GuiGraphics drawContext, int mouseX, int mouseY) {
        boolean overUnselection;
        Minecraft client = Minecraft.getInstance();
        boolean bl = overUnselection = (double)mouseX >= (double)this.selectedDotX && (double)mouseX < (double)(this.selectedDotX + 4) && (double)mouseY >= (double)this.selectedDotY && (double)mouseY < (double)(this.selectedDotY + 4);
        if (overUnselection) {
            drawContext.renderTooltip(client.font, List.of(Component.translatable((String)"pastel.tooltip.ink_powered.unselect_color")), Optional.empty(), this.getX(), this.getY());
        } else {
            int yOffset;
            int verticalColorOffset;
            int xOffset = Mth.floor((float)mouseX) - this.getX();
            int horizontalColorOffset = xOffset / 7;
            int newColorIndex = horizontalColorOffset + (verticalColorOffset = (yOffset = Mth.floor((float)mouseY) - this.getY()) / 7) * 8;
            Tuple<InkColor, Boolean> hoveredColor = this.usableColors.get(newColorIndex);
            if (((Boolean)hoveredColor.getB()).booleanValue()) {
                drawContext.renderTooltip(client.font, List.of(((InkColor)hoveredColor.getA()).getName()), Optional.empty(), this.getX(), this.getY());
            } else {
                drawContext.renderTooltip(client.font, List.of(Component.translatable((String)"pastel.tooltip.ink_powered.unselect_color")), Optional.empty(), this.getX(), this.getY());
            }
        }
    }
}

