/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ItemWithTooltip
extends Item {
    private final List<MutableComponent> tooltipTexts = new ArrayList<MutableComponent>();

    public ItemWithTooltip(Item.Properties settings, String tooltip) {
        super(settings);
        this.tooltipTexts.add(Component.translatable((String)tooltip));
    }

    public ItemWithTooltip(Item.Properties settings, String[] tooltips) {
        super(settings);
        Arrays.stream(tooltips).map(Component::translatable).forEach(this.tooltipTexts::add);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        for (MutableComponent text : this.tooltipTexts) {
            tooltip.add((Component)text.withStyle(ChatFormatting.GRAY));
        }
    }
}

