/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.items.magic_items.StructureCompassItem;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelStructureTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysteriousCompassItem
extends StructureCompassItem
implements SlotBackgroundEffect {
    public MysteriousCompassItem(Item.Properties settings) {
        super(settings, PastelStructureTags.MYSTERIOUS_COMPASS_LOCATED);
    }

    @Override
    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide && world.getGameTime() % 200L == 0L && entity instanceof Player) {
            Player player = (Player)entity;
            if (DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.MYSTERIOUS_LOCKET_SOCKETING)) {
                this.locateStructure(stack, world, entity);
            } else {
                this.removeStructurePos(stack);
            }
        }
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.FULL_PACKAGE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return 0xFFFFFF;
    }
}

