/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.item.LoomPatternProvider;
import earth.terrarium.pastel.registries.PastelBannerPatterns;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BannerPattern;

public class PigmentItem
extends Item
implements LoomPatternProvider {
    private static final Object2ObjectArrayMap<InkColor, PigmentItem> PIGMENTS = new Object2ObjectArrayMap();
    protected final InkColor color;
    public final Item hiddenAs;

    public PigmentItem(Item.Properties settings, InkColor color, Item hiddenAs) {
        super(settings);
        this.color = color;
        this.hiddenAs = hiddenAs;
        PIGMENTS.put((Object)color, (Object)this);
    }

    public InkColor getInkColor() {
        return this.color;
    }

    public static PigmentItem byColor(InkColor inkColor) {
        return (PigmentItem)PIGMENTS.get((Object)inkColor);
    }

    @Override
    public ResourceKey<BannerPattern> getPattern() {
        return PastelBannerPatterns.PIGMENT;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.addBannerPatternProviderTooltip(tooltip);
    }
}

