/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.bundles;

import earth.terrarium.pastel.components.ExtendedBundleComponent;
import earth.terrarium.pastel.mixin.accessors.BundleContentsComponentAccessor;
import earth.terrarium.pastel.mixin.accessors.BundleContentsComponentBuilderAccessor;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class ExtendedBundleItem
extends BundleItem {
    public ExtendedBundleItem(Item.Properties settings) {
        super(settings.component(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY));
    }

    public int getBarWidth(ItemStack stack) {
        if (ExtendedBundleItem.ignoreStacks(stack)) {
            return super.getBarWidth(stack);
        }
        return Math.min(1 + Mth.mulAndTruncate((Fraction)Fraction.getFraction((int)ExtendedBundleItem.getStacks(stack).size(), (int)ExtendedBundleItem.getMaxStacks(stack)), (int)12), 13);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        for (ItemStack bundled : ExtendedBundleItem.getStacks(stack)) {
            bundled.inventoryTick(world, entity, slot, selected);
        }
    }

    public static List<ItemStack> getStacks(ItemStack stack) {
        return ((BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).itemCopyStream().toList();
    }

    public static Fraction getMaxOccupancy(ItemStack stack) {
        return ((ExtendedBundleComponent)stack.getOrDefault(PastelDataComponentTypes.EXTENDED_BUNDLE, (Object)ExtendedBundleComponent.DEFAULT)).maxOccupancy();
    }

    public static int getMaxStacks(ItemStack stack) {
        return ((ExtendedBundleComponent)stack.getOrDefault(PastelDataComponentTypes.EXTENDED_BUNDLE, (Object)ExtendedBundleComponent.DEFAULT)).maxStacks();
    }

    public static boolean ignoreStacks(ItemStack stack) {
        return ((ExtendedBundleComponent)stack.getOrDefault(PastelDataComponentTypes.EXTENDED_BUNDLE, (Object)ExtendedBundleComponent.DEFAULT)).ignoreStacks();
    }

    public static class ComponentBuilder
    extends BundleContents.Mutable {
        private final Fraction maxOccupancy;
        private final int maxStacks;

        public ComponentBuilder(BundleContents base, Fraction maxOccupancy, int maxStacks) {
            super(base);
            this.maxOccupancy = maxOccupancy;
            this.maxStacks = maxStacks;
        }

        protected int findStackIndex(ItemStack stack) {
            if (stack.isStackable()) {
                List<ItemStack> stacks = ((BundleContentsComponentBuilderAccessor)((Object)this)).getItems();
                for (int i = 0; i < stacks.size(); ++i) {
                    ItemStack slotStack = stacks.get(i);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
                    return i;
                }
            }
            return -1;
        }

        public int tryInsert(ItemStack stack) {
            int added;
            int total = 0;
            while ((added = super.tryInsert(stack)) > 0) {
                total += added;
            }
            return total;
        }

        protected int getMaxAmountToAdd(ItemStack stack) {
            Fraction remainingOccupancy = this.maxOccupancy.subtract(this.weight());
            Fraction itemOccupancy = BundleContentsComponentAccessor.invokeGetWeight(stack);
            int allowedByOccupancy = Math.max(remainingOccupancy.divideBy(itemOccupancy).intValue(), 0);
            List<ItemStack> stacks = ((BundleContentsComponentBuilderAccessor)((Object)this)).getItems();
            int allowedByStacks = 0;
            for (int i = 0; i < Math.min(this.maxStacks, stacks.size()); ++i) {
                ItemStack slotStack = stacks.get(i);
                if (slotStack.isEmpty()) {
                    allowedByStacks += stack.getMaxStackSize();
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack)) continue;
                allowedByStacks += slotStack.getMaxStackSize() - stack.getCount();
            }
            return Math.min(allowedByOccupancy, allowedByStacks);
        }
    }
}

