/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.conditional;

import earth.terrarium.pastel.api.item.DamageAwareItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class StormStoneItem
extends Item
implements DamageAwareItem {
    public StormStoneItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public void onItemEntityDamaged(DamageSource source, float amount, ItemEntity itemEntity) {
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            this.doLightningExplosion(itemEntity);
        }
    }

    private void doLightningExplosion(ItemEntity itemEntity) {
        LightningBolt lightningEntity;
        ItemStack thisItemStack = itemEntity.getItem();
        Level world = itemEntity.getCommandSenderWorld();
        BlockPos blockPos = itemEntity.blockPosition();
        Vec3 pos = itemEntity.position();
        int count = thisItemStack.getCount();
        itemEntity.remove(Entity.RemovalReason.KILLED);
        if (world.canSeeSky(itemEntity.blockPosition()) && (lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world)) != null) {
            lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)blockPos));
            world.addFreshEntity((Entity)lightningEntity);
        }
        float powerMod = 1.0f;
        Biome biomeAtPos = (Biome)world.getBiome(blockPos).value();
        if (!biomeAtPos.hasPrecipitation() && !biomeAtPos.coldEnoughToSnow(blockPos)) {
            powerMod = world.isThundering() ? 1.5f : (world.isRaining() ? 1.25f : 1.0f);
        }
        world.explode((Entity)itemEntity, pos.x(), pos.y(), pos.z(), (float)count * powerMod, Level.ExplosionInteraction.MOB);
    }
}

