/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.energy;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.CreativeInkStorage;
import earth.terrarium.pastel.api.item.CreativeOnlyItem;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CreativeInkAssortmentItem
extends Item
implements InkStorageItem<CreativeInkStorage>,
CreativeOnlyItem,
SlotBackgroundEffect {
    public CreativeInkAssortmentItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level world = context.getLevel();
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(context.getClickedPos())) instanceof InkStorageBlockEntity) {
            InkStorageBlockEntity inkStorageBlockEntity = (InkStorageBlockEntity)blockEntity;
            inkStorageBlockEntity.getEnergyStorage().fillCompletely();
            inkStorageBlockEntity.setInkDirty();
            blockEntity.setChanged();
        }
        return super.useOn(context);
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.ALWAYS;
    }

    @Override
    public CreativeInkStorage getEnergyStorage(ItemStack itemStack) {
        return new CreativeInkStorage();
    }

    @Override
    public ItemStack getDefaultInstance() {
        return super.getDefaultInstance();
    }

    @Override
    public void setEnergyStorage(ItemStack itemStack, InkStorage storage) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        CreativeOnlyItem.appendTooltip(tooltip);
        this.getEnergyStorage(stack).addTooltip(tooltip);
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float delta) {
        ArrayList<InkColor> colors = new ArrayList<InkColor>();
        if (player == null) {
            return 0;
        }
        long time = player.level().getGameTime() % 864000L;
        for (InkColor inkColor : PastelRegistries.INK_COLOR) {
            colors.add(inkColor);
        }
        if (colors.size() == 1) {
            InkColor color = (InkColor)colors.getFirst();
            return ColorHelper.colorVecToRGB(color.getColorVec());
        }
        InkColor curColor = (InkColor)colors.get((int)(time % (30L * (long)colors.size()) / 30L));
        InkColor nextColor = (InkColor)colors.get((int)((time % (30L * (long)colors.size()) / 30L + 1L) % (long)colors.size()));
        float blendFactor = ((float)time + delta) % 30.0f / 30.0f;
        return ColorHelper.interpolate(curColor.getTextColorVec(), nextColor.getTextColorVec(), blendFactor);
    }
}

