/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.energy;

import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.SingleInkStorage;
import earth.terrarium.pastel.api.item.LoomPatternProvider;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBannerPatterns;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InkFlaskItem
extends Item
implements InkStorageItem<SingleInkStorage>,
LoomPatternProvider,
ExtendedItemBar {
    private final long maxEnergy;

    public InkFlaskItem(Item.Properties settings, long maxEnergy) {
        super(settings);
        this.maxEnergy = maxEnergy;
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.ALWAYS;
    }

    @Override
    public SingleInkStorage getEnergyStorage(ItemStack itemStack) {
        Iterator<Map.Entry<InkColor, Long>> iterator;
        InkStorageComponent storage = (InkStorageComponent)itemStack.get(PastelDataComponentTypes.INK_STORAGE);
        if (storage != null && (iterator = storage.storedEnergy().entrySet().iterator()).hasNext()) {
            Map.Entry<InkColor, Long> entry = iterator.next();
            return new SingleInkStorage(storage.maxEnergyTotal(), entry.getKey(), entry.getValue());
        }
        return new SingleInkStorage(this.maxEnergy);
    }

    @Override
    public ItemStack getDefaultInstance() {
        return super.getDefaultInstance();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.getEnergyStorage(stack).addTooltip(tooltip);
        this.addBannerPatternProviderTooltip(tooltip);
    }

    public ItemStack getFullStack(InkColor color) {
        ItemStack stack = this.getDefaultInstance();
        SingleInkStorage storage = this.getEnergyStorage(stack);
        storage.fillCompletely();
        storage.convertColor(color);
        this.setEnergyStorage(stack, storage);
        return stack;
    }

    @Override
    public ResourceKey<BannerPattern> getPattern() {
        return PastelBannerPatterns.INK_FLASK;
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        SingleInkStorage storage = this.getEnergyStorage(stack);
        if (storage.isEmpty()) {
            return ExtendedItemBar.PASS;
        }
        InkColor color = storage.getStoredColor();
        int progress = Support.getSensiblePercent(storage.getCurrentTotal(), storage.getMaxTotal(), 14);
        return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, color.getColorInt(), 2, -16777216);
    }
}

