/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.food;

import earth.terrarium.pastel.items.food.DrinkItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class StatusEffectDrinkItem
extends DrinkItem {
    public StatusEffectDrinkItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        Player playerEntity;
        Player player = playerEntity = user instanceof Player ? (Player)user : null;
        if (playerEntity instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)playerEntity, stack);
        }
        if (!world.isClientSide) {
            PotionContents potionContentsComponent = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            potionContentsComponent.forEachEffect(effect -> {
                if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                    ((MobEffect)effect.getEffect().value()).applyInstantenousEffect((Entity)playerEntity, (Entity)playerEntity, user, effect.getAmplifier(), 1.0);
                } else {
                    user.addEffect(effect);
                }
            });
        }
        if (playerEntity != null) {
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        user.gameEvent((Holder)GameEvent.DRINK);
        return super.finishUsingItem(stack, world, user);
    }
}

