/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.item.PrioritizedBlockInteraction;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.helpers.level.BuildingHelper;
import earth.terrarium.pastel.registries.PastelBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Triplet;

public abstract class BuildingStaffItem
extends Item
implements PrioritizedBlockInteraction,
InkPowered {
    public static final InkColor USED_COLOR = InkColors.CYAN;

    public BuildingStaffItem(Item.Properties settings) {
        super(settings);
    }

    public boolean canInteractWith(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        if (state.getBlock().asItem() == Items.AIR) {
            return false;
        }
        if (player == null || world.getBlockEntity(pos) != null || state.is(PastelBlockTags.BUILDING_STAFFS_BLACKLISTED)) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        float hardness = state.getDestroySpeed(world, pos);
        return hardness >= 0.0f && GenericClaimModsCompat.canInteract(player.level(), pos, (Entity)player);
    }

    protected static Triplet<Block, Item, Integer> countSuitableReplacementItems(@NotNull Player player, @NotNull Block targetBlock, boolean single, int inkCostPerBlock) {
        if (player.isCreative()) {
            return new Triplet((Object)targetBlock, (Object)targetBlock.asItem(), (Object)(single ? 1 : Integer.MAX_VALUE));
        }
        long blocksToPlace = single ? (InkPowered.getAvailableInk(player, USED_COLOR) >= (long)inkCostPerBlock ? 1L : 0L) : InkPowered.getAvailableInk(player, USED_COLOR) / (long)inkCostPerBlock;
        blocksToPlace = Math.min(1024L, blocksToPlace);
        return BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars(player, targetBlock, blocksToPlace);
    }

    public static class BuildingStaffPlacementContext
    extends BlockPlaceContext {
        public BuildingStaffPlacementContext(Level world, @Nullable Player playerEntity, BlockHitResult blockHitResult) {
            super(world, playerEntity, InteractionHand.MAIN_HAND, ItemStack.EMPTY, blockHitResult);
        }
    }
}

