/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.helpers.level.BuildingHelper;
import earth.terrarium.pastel.items.magic_items.BuildingStaffItem;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import oshi.util.tuples.Triplet;

public class ConstructorsStaffItem
extends BuildingStaffItem {
    public static final int INK_COST_PER_BLOCK = 1;
    public static final int CREATIVE_RANGE = 10;

    public ConstructorsStaffItem(Item.Properties settings) {
        super(settings);
    }

    public static int getRange(Player playerEntity) {
        if (playerEntity == null || playerEntity.isCreative()) {
            return 10;
        }
        Optional<PedestalTier> highestUnlockedRecipeTier = PedestalTier.getHighestUnlockedRecipeTier(playerEntity);
        if (highestUnlockedRecipeTier.isPresent()) {
            switch (highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    return 10;
                }
                case ADVANCED: {
                    return 7;
                }
            }
            return 4;
        }
        return 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.constructors_staff.tooltip.range", (Object[])new Object[]{ConstructorsStaffItem.getRange((Player)Minecraft.getInstance().player)}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.constructors_staff.tooltip.crouch").withStyle(ChatFormatting.GRAY));
        this.addInkPoweredTooltip(tooltip);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState targetBlockState = world.getBlockState(pos);
        if (player != null && this.canInteractWith(targetBlockState, (BlockGetter)context.getLevel(), context.getClickedPos(), context.getPlayer())) {
            long count;
            Item itemToConsume;
            Block blockToPlace = targetBlockState.getBlock();
            if (player.isCreative()) {
                itemToConsume = blockToPlace.asItem();
                count = Integer.MAX_VALUE;
            } else {
                Triplet<Block, Item, Integer> replaceData = ConstructorsStaffItem.countSuitableReplacementItems(player, blockToPlace, false, 1);
                blockToPlace = (Block)replaceData.getA();
                itemToConsume = (Item)replaceData.getB();
                count = ((Integer)replaceData.getC()).intValue();
            }
            if (count > 0L) {
                boolean sneaking;
                int maxRange;
                int range;
                Direction side = context.getClickedFace();
                List<BlockPos> targetPositions = BuildingHelper.calculateBuildingStaffSelection(world, pos, side, count, range = (int)Math.min((long)(maxRange = ConstructorsStaffItem.getRange(player)), player.isCreative() ? (long)maxRange : count), !(sneaking = player.isShiftKeyDown()));
                if (targetPositions.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                if (!world.isClientSide) {
                    ConstructorsStaffItem.placeBlocksAndDecrementInventory(player, world, blockToPlace, itemToConsume, side, targetPositions);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (player != null) {
            world.playSound(null, player.blockPosition(), SoundEvents.DISPENSER_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.FAIL;
    }

    protected static void placeBlocksAndDecrementInventory(Player player, Level world, Block blockToPlace, Item itemToConsume, Direction side, List<BlockPos> targetPositions) {
        int placedBlocks = 0;
        for (BlockPos position : targetPositions) {
            BlockState stateToPlace;
            BlockState originalState;
            if (!GenericClaimModsCompat.canPlaceBlock(world, position, (Entity)player) || !(originalState = world.getBlockState(position)).isAir() && !(originalState.getBlock() instanceof LiquidBlock) && (!originalState.canBeReplaced() || !originalState.getCollisionShape((BlockGetter)world, position).isEmpty()) || (stateToPlace = blockToPlace.getStateForPlacement((BlockPlaceContext)new BuildingStaffItem.BuildingStaffPlacementContext(world, player, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)position), side, position, false)))) == null || !stateToPlace.canSurvive((LevelReader)world, position) || !world.setBlockAndUpdate(position, stateToPlace)) continue;
            if (placedBlocks == 0) {
                world.playSound(null, player.blockPosition(), stateToPlace.getSoundType().getPlaceSound(), SoundSource.PLAYERS, stateToPlace.getSoundType().getVolume(), stateToPlace.getSoundType().getPitch());
            }
            ++placedBlocks;
        }
        if (!player.isCreative()) {
            InventoryHelper.removeFromInventoryWithRemainders(player, new ItemStack((ItemLike)itemToConsume, placedBlocks));
            InkPowered.tryDrainEnergy(player, USED_COLOR, (long)targetPositions.size() * 1L);
        }
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }
}

