/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentCanvasItem
extends Item {
    public EnchantmentCanvasItem(Item.Properties settings) {
        super(settings);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickType, Player player) {
        ItemStack otherStack;
        if (clickType == ClickAction.SECONDARY && (otherStack = slot.getItem()).getCount() == 1 && EnchantmentCanvasItem.tryExchangeEnchantments(stack, otherStack, (Entity)player)) {
            if (player != null) {
                this.playExchangeSound((Entity)player);
            }
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.SECONDARY && otherStack.getCount() == 1 && slot.allowModification(player) && EnchantmentCanvasItem.tryExchangeEnchantments(stack, otherStack, (Entity)player)) {
            if (player != null) {
                this.playExchangeSound((Entity)player);
            }
            return true;
        }
        return false;
    }

    public static boolean tryExchangeEnchantments(ItemStack canvasStack, ItemStack targetStack, @Nullable Entity receiver) {
        Optional<Item> itemLock = EnchantmentCanvasItem.getItemBoundTo(canvasStack);
        if (itemLock.isPresent() && !targetStack.is(itemLock.get())) {
            return false;
        }
        ItemEnchantments canvasEnchantments = (ItemEnchantments)canvasStack.getOrDefault(PastelDataComponentTypes.CANVAS_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments targetEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)targetStack);
        if (canvasEnchantments.isEmpty() && targetEnchantments.isEmpty()) {
            return false;
        }
        boolean drop = false;
        if (canvasStack.getCount() >= 1) {
            canvasStack = canvasStack.split(1);
            drop = true;
        }
        if (itemLock.isEmpty() && !targetEnchantments.isEmpty()) {
            EnchantmentCanvasItem.bindTo(canvasStack, targetStack);
        }
        canvasStack.set(PastelDataComponentTypes.CANVAS_ENCHANTMENTS, (Object)targetEnchantments);
        EnchantmentHelper.setEnchantments((ItemStack)targetStack, (ItemEnchantments)canvasEnchantments);
        if (drop && receiver != null) {
            if (receiver instanceof Player) {
                Player player = (Player)receiver;
                player.getInventory().placeItemBackInInventory(canvasStack);
            } else {
                receiver.spawnAtLocation(canvasStack);
            }
        }
        return true;
    }

    private void playExchangeSound(Entity entity) {
        entity.playSound(SoundEvents.GRINDSTONE_USE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Optional<Item> boundItem = EnchantmentCanvasItem.getItemBoundTo(stack);
        if (boundItem.isPresent()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.enchantment_canvas.tooltip.bound_to").append(boundItem.get().getDescription()));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.enchantment_canvas.tooltip.not_bound"));
            tooltip.add((Component)Component.translatable((String)"item.pastel.enchantment_canvas.tooltip.not_bound2"));
        }
    }

    private static void bindTo(ItemStack enchantmentExchangerStack, ItemStack targetStack) {
        enchantmentExchangerStack.set(PastelDataComponentTypes.BOUND_ITEM, (Object)BuiltInRegistries.ITEM.getKey((Object)targetStack.getItem()));
    }

    private static Optional<Item> getItemBoundTo(ItemStack enchantmentExchangerStack) {
        ResourceLocation boundId = (ResourceLocation)enchantmentExchangerStack.get(PastelDataComponentTypes.BOUND_ITEM);
        if (boundId == null) {
            return Optional.empty();
        }
        return Optional.of((Item)BuiltInRegistries.ITEM.get(boundId));
    }
}

