/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.components.EnderSpliceComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.networking.c2s_payloads.BindEnderSpliceToPlayerPayload;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.EnderSpliceChargingSoundInstance;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EnderSpliceItem
extends Item {
    public EnderSpliceItem(Item.Properties settings) {
        super(settings);
    }

    public static boolean isSameWorld(Level world1, Level world2) {
        return world1.dimension().location().toString().equals(world2.dimension().location().toString());
    }

    public static void setTeleportTargetPos(@NotNull ItemStack itemStack, Level world, Vec3 pos) {
        itemStack.set(PastelDataComponentTypes.ENDER_SPLICE, (Object)new EnderSpliceComponent(pos, (ResourceKey<Level>)world.dimension()));
    }

    public static void setTeleportTargetPlayer(@NotNull ItemStack itemStack, ServerPlayer player) {
        itemStack.set(PastelDataComponentTypes.ENDER_SPLICE, (Object)new EnderSpliceComponent(player.getName().getString(), player.getUUID()));
    }

    public static boolean hasTeleportTarget(ItemStack itemStack) {
        return itemStack.has(PastelDataComponentTypes.ENDER_SPLICE);
    }

    public static void clearTeleportTarget(ItemStack itemStack) {
        itemStack.remove(PastelDataComponentTypes.ENDER_SPLICE);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level world, LivingEntity user) {
        if (world.isClientSide) {
            if (this.getTeleportTargetPos(itemStack).isEmpty() && this.getTeleportTargetPlayerUUID(itemStack).isEmpty()) {
                this.interactWithEntityClient();
            }
        } else if (user instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(playerEntity, itemStack);
            boolean resonance = EnchantmentHelper.hasTag((ItemStack)itemStack, PastelEnchantmentTags.DIMENSIONAL_TELEPORT);
            Optional<Tuple<ResourceKey<Level>, Vec3>> teleportTargetPos = this.getTeleportTargetPos(itemStack);
            if (teleportTargetPos.isPresent()) {
                ServerLevel targetWorld = world.getServer().getLevel((ResourceKey)teleportTargetPos.get().getA());
                if (this.teleportPlayerToPos(world, user, (Player)playerEntity, (Level)targetWorld, (Vec3)teleportTargetPos.get().getB(), resonance)) {
                    EnderSpliceItem.decrementWithChance(itemStack, world, playerEntity);
                }
            } else {
                Optional<UUID> teleportTargetPlayerUUID = this.getTeleportTargetPlayerUUID(itemStack);
                if (teleportTargetPlayerUUID.isPresent()) {
                    if (this.teleportPlayerToPlayerWithUUID(world, user, (Player)playerEntity, teleportTargetPlayerUUID.get(), resonance)) {
                        EnderSpliceItem.decrementWithChance(itemStack, world, playerEntity);
                    }
                } else {
                    EnderSpliceItem.setTeleportTargetPos(itemStack, playerEntity.getCommandSenderWorld(), playerEntity.position());
                    world.playSound(null, playerEntity.blockPosition(), PastelSounds.ENDER_SPLICE_BOUND, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return itemStack;
    }

    private static void decrementWithChance(ItemStack itemStack, Level world, ServerPlayer playerEntity) {
        if (EnchantmentHelper.hasTag((ItemStack)itemStack, PastelEnchantmentTags.INDESTRUCTIBLE_EFFECT)) {
            return;
        }
        if (!playerEntity.getAbilities().instabuild) {
            int unbreakingLevel = Ench.getLevel((HolderLookup.Provider)world.registryAccess(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING, itemStack);
            if (unbreakingLevel == 0) {
                itemStack.shrink(1);
            } else {
                itemStack.shrink(Support.chanceRound(1.0 / (double)(1 + unbreakingLevel), world.random));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void interactWithEntityClient() {
        Entity entity;
        Minecraft client = Minecraft.getInstance();
        HitResult hitResult = client.hitResult;
        if (hitResult != null && hitResult.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).getEntity()) instanceof Player) {
            Player playerEntity = (Player)entity;
            PacketDistributor.sendToServer((CustomPacketPayload)new BindEnderSpliceToPlayerPayload(playerEntity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private boolean teleportPlayerToPlayerWithUUID(Level world, LivingEntity user, Player playerEntity, UUID targetPlayerUUID, boolean hasResonance) {
        Player targetPlayer = PlayerOwned.getPlayerEntityIfOnline(targetPlayerUUID);
        if (targetPlayer != null) {
            return this.teleportPlayerToPos(targetPlayer.getCommandSenderWorld(), user, playerEntity, targetPlayer.getCommandSenderWorld(), targetPlayer.position(), hasResonance);
        }
        return false;
    }

    private boolean teleportPlayerToPos(Level world, LivingEntity user, Player playerEntity, Level targetWorld, Vec3 targetPos, boolean hasResonance) {
        boolean isSameWorld = EnderSpliceItem.isSameWorld(user.getCommandSenderWorld(), targetWorld);
        Vec3 currentPos = playerEntity.position();
        if ((hasResonance || isSameWorld) && targetWorld instanceof ServerLevel) {
            ServerLevel targetServerWorld = (ServerLevel)targetWorld;
            world.playSound(playerEntity, currentPos.x(), currentPos.y(), currentPos.z(), PastelSounds.PLAYER_TELEPORTS, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!isSameWorld) {
                user.changeDimension(new DimensionTransition(targetServerWorld, targetPos.add(0.0, 0.25, 0.0), new Vec3(0.0, 0.0, 0.0), user.getYRot(), user.getXRot(), DimensionTransition.DO_NOTHING));
            } else {
                user.teleportTo(targetPos.x(), targetPos.y + 0.25, targetPos.z);
            }
            world.playSound(playerEntity, targetPos.x(), targetPos.y, targetPos.z, PastelSounds.PLAYER_TELEPORTS, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (playerEntity instanceof ServerPlayer) {
                world.playSound(null, playerEntity.blockPosition(), PastelSounds.PLAYER_TELEPORTS, SoundSource.PLAYERS, 1.0f, 1.0f);
                world.playSound(null, playerEntity.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        user.releaseUsingItem();
        world.playSound(null, currentPos.x(), currentPos.y(), currentPos.z(), PastelSounds.USE_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide) {
            this.startSoundInstance(user);
        }
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSoundInstance(Player user) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new EnderSpliceChargingSoundInstance(user));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 48;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Optional<Tuple<ResourceKey<Level>, Vec3>> teleportTargetPos = this.getTeleportTargetPos(stack);
        if (teleportTargetPos.isPresent()) {
            String dimensionDisplayString = Support.getReadableDimensionString(((ResourceKey)teleportTargetPos.get().getA()).location().toString());
            Vec3 pos = (Vec3)teleportTargetPos.get().getB();
            tooltip.add((Component)Component.translatable((String)"item.pastel.ender_splice.tooltip.bound_pos", (Object[])new Object[]{(int)pos.x, (int)pos.y, (int)pos.z, dimensionDisplayString}));
            return;
        }
        Optional<UUID> teleportTargetPlayerUUID = this.getTeleportTargetPlayerUUID(stack);
        if (teleportTargetPlayerUUID.isPresent()) {
            Optional<String> teleportTargetPlayerName = this.getTeleportTargetPlayerName(stack);
            if (teleportTargetPlayerName.isPresent()) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.ender_splice.tooltip.bound_player", (Object[])new Object[]{teleportTargetPlayerName.get()}));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.ender_splice.tooltip.bound_player", (Object[])new Object[]{"???"}));
            }
            return;
        }
        tooltip.add((Component)Component.translatable((String)"item.pastel.ender_splice.tooltip.unbound"));
    }

    public Optional<Tuple<ResourceKey<Level>, Vec3>> getTeleportTargetPos(@NotNull ItemStack itemStack) {
        EnderSpliceComponent component = (EnderSpliceComponent)itemStack.getOrDefault(PastelDataComponentTypes.ENDER_SPLICE, (Object)EnderSpliceComponent.DEFAULT);
        if (component.pos().isPresent() && component.dimension().isPresent()) {
            return Optional.of(new Tuple(component.dimension().get(), (Object)component.pos().get()));
        }
        return Optional.empty();
    }

    public Optional<UUID> getTeleportTargetPlayerUUID(@NotNull ItemStack itemStack) {
        return ((EnderSpliceComponent)itemStack.getOrDefault(PastelDataComponentTypes.ENDER_SPLICE, (Object)EnderSpliceComponent.DEFAULT)).targetUUID();
    }

    public Optional<String> getTeleportTargetPlayerName(@NotNull ItemStack itemStack) {
        return ((EnderSpliceComponent)itemStack.getOrDefault(PastelDataComponentTypes.ENDER_SPLICE, (Object)EnderSpliceComponent.DEFAULT)).targetName();
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 50;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(PastelEnchantments.RESONANCE) || enchantment.is(PastelEnchantments.INDESTRUCTIBLE) || enchantment.is(Enchantments.UNBREAKING);
    }
}

