/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.block.ColorableBlock;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.interaction.EntityColorProcessorRegistry;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.entity.entity.InkProjectileEntity;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.helpers.level.BlockVariantHelper;
import earth.terrarium.pastel.inventories.PaintbrushScreenHandler;
import earth.terrarium.pastel.items.PigmentItem;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.Nullable;

public class PaintbrushItem
extends Item
implements SignApplicator {
    public static final int COOLDOWN_DURATION_TICKS = 10;
    public static final int BLOCK_COLOR_COST = 25;
    public static final int INK_SLING_COST = 100;

    public PaintbrushItem(Item.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (EffectiveSide.get().isClient()) {
            PaintbrushItem.appendClientTooltips(stack, tooltip);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void appendClientTooltips(ItemStack stack, List<Component> tooltip) {
        Optional<InkColor> color;
        boolean unlockedColoring = DatabankUtils.hasAdvancementClient((ResourceLocation)PastelAdvancements.PAINTBRUSH_COLORING);
        boolean unlockedSlinging = DatabankUtils.hasAdvancementClient((ResourceLocation)PastelAdvancements.PAINTBRUSH_INK_SLINGING);
        if ((unlockedColoring || unlockedSlinging) && (color = PaintbrushItem.getColor(stack)).isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.paintbrush.tooltip.select_color"));
        }
        tooltip.add((Component)Component.translatable((String)"item.pastel.paintbrush.ability.header").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.paintbrush.ability.pedestal_triggering").withStyle(ChatFormatting.GRAY));
        if (unlockedColoring) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.paintbrush.ability.block_coloring").withStyle(ChatFormatting.GRAY));
        }
        if (unlockedSlinging) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.paintbrush.ability.ink_slinging").withStyle(ChatFormatting.GRAY));
        }
    }

    public static boolean canColor(Player player) {
        return DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.PAINTBRUSH_COLORING);
    }

    public static boolean canInkSling(Player player) {
        return DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)PastelAdvancements.PAINTBRUSH_INK_SLINGING);
    }

    public MenuProvider createScreenHandlerFactory(ItemStack itemStack) {
        return new SimpleMenuProvider((syncId, inventory, player) -> new PaintbrushScreenHandler(syncId, inventory, itemStack), (Component)Component.translatable((String)"item.pastel.paintbrush"));
    }

    public Component getName(ItemStack stack) {
        MutableComponent name = Component.translatable((String)this.getDescriptionId(stack));
        Optional<InkColor> color = PaintbrushItem.getColor(stack);
        if (color.isPresent()) {
            InkColor inkColor = color.get();
            name = inkColor.getColoredName().append(" ").append((Component)name);
        }
        return name;
    }

    public static void setColor(ItemStack stack, @Nullable InkColor color) {
        stack.set(PastelDataComponentTypes.INK_COLOR, (Object)color);
    }

    public static Optional<InkColor> getColor(ItemStack stack) {
        return Optional.ofNullable((InkColor)stack.get(PastelDataComponentTypes.INK_COLOR));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (PaintbrushItem.canColor(context.getPlayer()) && this.tryColorBlock(context)) {
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useOn(context);
    }

    private boolean tryColorBlock(UseOnContext context) {
        BlockPos pos;
        Optional<InkColor> inkColor = PaintbrushItem.getColor(context.getItemInHand());
        if (inkColor.isEmpty()) {
            return false;
        }
        Optional<DyeColor> dyeColor = inkColor.get().getDyeColor();
        Level world = context.getLevel();
        BlockState state = world.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof ColorableBlock) {
            ColorableBlock colorableBlock = (ColorableBlock)block;
            if (!colorableBlock.isColor(world, pos, dyeColor)) {
                if (this.payBlockColorCost(context.getPlayer(), inkColor.get()) && colorableBlock.color(world, pos, dyeColor, (Entity)context.getPlayer())) {
                    context.getLevel().playSound(null, context.getClickedPos(), PastelSounds.PAINTBRUSH_PAINT, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    context.getLevel().playSound(null, context.getClickedPos(), PastelSounds.USE_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            return false;
        }
        return this.cursedColor(context);
    }

    private boolean cursedColor(UseOnContext context) {
        Level world = context.getLevel();
        if (context.getPlayer() == null) {
            return false;
        }
        Optional<InkColor> optionalInkColor = PaintbrushItem.getColor(context.getItemInHand());
        if (optionalInkColor.isEmpty()) {
            return false;
        }
        InkColor inkColor = optionalInkColor.get();
        Optional<DyeColor> optionalDyeColor = inkColor.getDyeColor();
        if (optionalDyeColor.isEmpty()) {
            return false;
        }
        DyeColor dyeColor = optionalDyeColor.get();
        BlockState newBlockState = BlockVariantHelper.getCursedBlockColorVariant(context.getLevel(), context.getClickedPos(), dyeColor);
        if (newBlockState.isAir()) {
            return false;
        }
        if (this.payBlockColorCost(context.getPlayer(), inkColor)) {
            if (!world.isClientSide) {
                world.setBlockAndUpdate(context.getClickedPos(), newBlockState);
                world.playSound(null, context.getClickedPos(), PastelSounds.PAINTBRUSH_PAINT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (world.isClientSide) {
            context.getPlayer().playSound(PastelSounds.USE_FAIL, 1.0f, 1.0f);
        }
        return false;
    }

    private boolean payBlockColorCost(Player player, InkColor inkColor) {
        if (player == null) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        if (InkPowered.tryDrainEnergy(player, inkColor, 25L)) {
            return true;
        }
        Optional<DyeColor> dyeColor = inkColor.getDyeColor();
        if (dyeColor.isEmpty()) {
            return false;
        }
        return InventoryHelper.removeFromInventoryWithRemainders(player, PigmentItem.byColor(inkColor).getDefaultInstance());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        Optional<InkColor> optionalInkColor;
        if (user.isShiftKeyDown()) {
            ServerPlayer serverPlayerEntity;
            if (user instanceof ServerPlayer && PaintbrushItem.canColor((Player)(serverPlayerEntity = (ServerPlayer)user))) {
                serverPlayerEntity.openMenu(this.createScreenHandlerFactory(user.getItemInHand(hand)));
            }
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        if (PaintbrushItem.canInkSling(user) && (optionalInkColor = PaintbrushItem.getColor(user.getItemInHand(hand))).isPresent()) {
            InkColor inkColor = optionalInkColor.get();
            if (user.isCreative() || InkPowered.tryDrainEnergy(user, inkColor, 100L)) {
                user.getCooldowns().addCooldown((Item)this, 10);
                if (!world.isClientSide) {
                    InkProjectileEntity.shoot(world, (LivingEntity)user, inkColor);
                }
                if (!user.isCreative()) {
                    if (inkColor == InkColors.RED) {
                        this.causeKnockback(user, user.getYRot(), user.getXRot(), 0.1f, 0.5f);
                    } else {
                        this.causeKnockback(user, user.getYRot(), user.getXRot(), 0.0f, 0.3f);
                    }
                }
            } else if (world.isClientSide) {
                user.playSound(PastelSounds.USE_FAIL, 1.0f, 1.0f);
            }
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        return super.use(world, user, hand);
    }

    private void causeKnockback(Player user, float yaw, float pitch, float roll, float multiplier) {
        float f = Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))) * multiplier;
        float g = Mth.sin((float)((pitch + roll) * ((float)Math.PI / 180))) * multiplier;
        float h = -Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))) * multiplier;
        user.push((double)f, (double)g, (double)h);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        Player player;
        Optional<InkColor> color;
        Level world = user.level();
        if (PaintbrushItem.canColor(user) && GenericClaimModsCompat.canInteract(entity.level(), (Entity)entity, (Entity)user) && (color = PaintbrushItem.getColor(stack)).isPresent() && this.payBlockColorCost(user, color.get()) && EntityColorProcessorRegistry.colorEntity((Entity)entity, color.get().getDyeColor(), entity instanceof Player ? (player = (Player)entity) : null)) {
            entity.level().playSound(null, (Entity)entity, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.interactLivingEntity(stack, user, entity, hand);
    }

    public boolean tryApplyToSign(Level world, SignBlockEntity signBlockEntity, boolean front, Player player) {
        if (this.tryUseOnSign(world, signBlockEntity, front, player, player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return true;
        }
        if (this.tryUseOnSign(world, signBlockEntity, front, player, player.getItemInHand(InteractionHand.OFF_HAND))) {
            return true;
        }
        player.playSound(PastelSounds.USE_FAIL, 1.0f, 1.0f);
        return false;
    }

    private boolean tryUseOnSign(Level world, SignBlockEntity signBlockEntity, boolean front, Player player, ItemStack stack) {
        Optional<InkColor> color;
        if (stack.is((Item)PastelItems.PAINTBRUSH.get()) && (color = PaintbrushItem.getColor(stack)).isPresent()) {
            InkColor inkColor = color.get();
            Optional<DyeColor> dyeColor = inkColor.getDyeColor();
            if (PaintbrushItem.canColor(player) && this.payBlockColorCost(player, inkColor) && signBlockEntity.updateText(signText -> {
                if (dyeColor.isPresent()) {
                    return signText.setColor((DyeColor)dyeColor.get());
                }
                return signText;
            }, front)) {
                world.playSound(null, signBlockEntity.getBlockPos(), PastelSounds.PAINTBRUSH_PAINT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }
}

