/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RadianceStaffItem
extends Item
implements InkPowered {
    public static final int USE_DURATION = 20;
    public static final int REACH_STEP_DISTANCE = 4;
    public static final int MAX_REACH_STEPS = 8;
    public static final int PLACEMENT_TRIES_PER_STEP = 4;
    public static final int MIN_LIGHT_LEVEL = 10;
    public static final InkCost INK_COST = new InkCost(InkColors.YELLOW, 10L);
    public static final ItemStack COST = new ItemStack((ItemLike)PastelItems.SHIMMERSTONE_GEM.get(), 1);

    public RadianceStaffItem(Item.Properties settings) {
        super(settings);
    }

    public static boolean placeLight(Level world, BlockPos targetPos, ServerPlayer playerEntity) {
        if (!GenericClaimModsCompat.canPlaceBlock(world, targetPos, (Entity)playerEntity)) {
            return false;
        }
        BlockState targetBlockState = world.getBlockState(targetPos);
        if (targetBlockState.isAir()) {
            if (playerEntity.isCreative() || InkPowered.tryDrainEnergy((Player)playerEntity, INK_COST) || InventoryHelper.removeFromInventoryWithRemainders((Player)playerEntity, COST)) {
                world.setBlock(targetPos, ((Block)PastelBlocks.WAND_LIGHT_BLOCK.get()).defaultBlockState(), 3);
                return true;
            }
        } else if (targetBlockState.is(Blocks.WATER) && (playerEntity.isCreative() || InkPowered.tryDrainEnergy((Player)playerEntity, INK_COST) || InventoryHelper.removeFromInventoryWithRemainders((Player)playerEntity, COST))) {
            world.setBlock(targetPos, (BlockState)((Block)PastelBlocks.WAND_LIGHT_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public static void playParticles(Level world, BlockPos targetPos, ServerPlayer playerEntity, int useTimes, int iteration) {
        if (useTimes % 2 == 0) {
            float pitch = Math.min(1.35f, 0.7f + 0.1f * (float)useTimes);
        } else {
            float pitch = Math.min(1.5f, 0.7f + 0.1f * (float)useTimes);
        }
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, Vec3.atCenterOf((Vec3i)targetPos), (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE, 20, Vec3.ZERO, new Vec3(0.3, 0.3, 0.3));
    }

    public static void playDenySound(Level world, Player playerEntity) {
        world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), PastelSounds.USE_FAIL, SoundSource.PLAYERS, 1.0f, 0.8f + playerEntity.getRandom().nextFloat() * 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (InkPowered.canUseClient()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.radiance_staff.tooltip.ink", (Object[])new Object[]{INK_COST.color().getColoredInkName()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.radiance_staff.tooltip"));
        }
        tooltip.add((Component)Component.translatable((String)"item.pastel.radiance_staff.tooltip2"));
        tooltip.add((Component)Component.translatable((String)"item.pastel.radiance_staff.tooltip3"));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        if (!level.isClientSide) {
            level.playSound(null, user.getX(), user.getY(), user.getZ(), PastelSounds.RADIANCE_STAFF_CHARGING, SoundSource.PLAYERS, 1.0f, Support.varFloatCentered(level.random, 0.1f));
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)user, (InteractionHand)hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            if (user.getTicksUsingItem() > 20 && user.getTicksUsingItem() % 20 == 0) {
                this.usage(world, serverPlayerEntity);
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Player user = context.getPlayer();
        if (user == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        if (!level.getBlockState(pos).is((Block)PastelBlocks.WAND_LIGHT_BLOCK.get())) {
            BlockPos targetPos = pos.relative(direction);
            if (RadianceStaffItem.placeLight(level, targetPos, (ServerPlayer)user)) {
                RadianceStaffItem.playParticles(level, targetPos, (ServerPlayer)user, level.random.nextInt(5), level.random.nextInt(5));
                RadianceStaffItem.playPlaceSound(level, user, Support.varFloatCentered(level.random, 0.2f), Support.varFloatCentered(level.random, 0.125f));
            } else {
                RadianceStaffItem.playDenySound(level, user);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void usage(Level level, ServerPlayer user) {
        int useTimes = user.getTicksUsingItem() / 20;
        int maxCheckDistance = Math.min(8, useTimes);
        BlockPos sourcePos = user.blockPosition();
        Vec3 cameraVec = user.getViewVector(0.0f);
        int successes = 0;
        block0: for (int iteration = 1; iteration < maxCheckDistance; ++iteration) {
            BlockPos targetPos = sourcePos.offset(Mth.floor((double)(cameraVec.x * (double)iteration * 4.0)), Mth.floor((double)(cameraVec.y * (double)iteration * 4.0)), Mth.floor((double)(cameraVec.z * (double)iteration * 4.0)));
            for (int tries = 0; tries < 4; ++tries) {
                if (level.getBrightness(LightLayer.BLOCK, targetPos = targetPos.offset(iteration - level.getRandom().nextInt(2 * iteration), iteration - level.getRandom().nextInt(2 * iteration), iteration - level.getRandom().nextInt(2 * iteration))) >= 10 || !RadianceStaffItem.placeLight(level, targetPos, user)) continue;
                RadianceStaffItem.playParticles(level, targetPos, user, useTimes, iteration);
                ++successes;
                continue block0;
            }
        }
        float pitch = level.random.nextFloat() * 0.09f + (float)successes * 0.1f;
        float vol = (float)Math.max(0.75, (double)((float)successes * 0.1f + 0.25f));
        RadianceStaffItem.playPlaceSound(level, (Player)user, vol, 1.0f + pitch);
        RadianceStaffItem.playPlaceSound(level, (Player)user, vol, 1.0f - pitch);
    }

    private static void playPlaceSound(Level level, Player user, float vol, float pitch) {
        level.playSound(null, (Entity)user, PastelSounds.RADIANCE_STAFF_PLACE, SoundSource.PLAYERS, vol, pitch);
    }

    public int getEnchantmentValue() {
        return 8;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(INK_COST.color());
    }
}

