/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items.ampoules;

import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.entity.entity.LightMineEntity;
import earth.terrarium.pastel.entity.entity.LightShardBaseEntity;
import earth.terrarium.pastel.items.magic_items.ampoules.GlassAmpouleItem;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MalachiteGlassAmpouleItem
extends GlassAmpouleItem
implements InkPoweredPotionFillable {
    public MalachiteGlassAmpouleItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public boolean trigger(Level world, ItemStack stack, @Nullable LivingEntity attacker, @Nullable LivingEntity target, Vec3 position) {
        ArrayList<MobEffectInstance> e = new ArrayList<MobEffectInstance>();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            List<InkPoweredStatusEffectInstance> effects = InkPoweredPotionFillable.getEffects(stack);
            for (InkPoweredStatusEffectInstance effect : effects) {
                if (!InkPowered.tryDrainEnergy(player, effect.getInkCost())) continue;
                e.add(effect.getStatusEffectInstance());
            }
        }
        if (e.isEmpty()) {
            return false;
        }
        world.playLocalSound(BlockPos.containing((Position)position), PastelSounds.LIGHT_CRYSTAL_RING, SoundSource.PLAYERS, 0.35f, 0.9f + world.getRandom().nextFloat() * 0.334f, true);
        LightMineEntity.summonBarrage(world, attacker, target, LightShardBaseEntity.MONSTER_TARGET, e, position, LightShardBaseEntity.DEFAULT_COUNT_PROVIDER);
        return true;
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.malachite_glass_ampoule.tooltip").withStyle(ChatFormatting.GRAY));
        this.appendPotionFillableTooltip(stack, tooltip, Component.translatable((String)"item.pastel.malachite_glass_ampoule.tooltip.when_hit"), false, context.tickRate());
    }
}

